(*  Title: 	ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Root file for pure Isabelle: all modules in proper order for loading
Loads pure Isabelle into an empty database.

To build system do the following two steps (or use the Makefile!!)

1. Invoke poly with a standard database and type
    ml(); PolyML.make_database("pure", "BASE"); PolyML.quit();
   [Omit first line if the banner says "Poly/ML" instead of "Poly".]

2. To load pure Isabelle, poly with this new database and type
    PolyML.use "ROOT.ML";

Then load ROOT.ML on subdirectory to add a logic to the database.

Use  exception_trace (fn () => E);
  to trace exceptions raised in E
*)

val version = "89/10";

open PolyML;  print_depth 1;  open BasicIO;

(*I/O.  Defines separate identifier for terminal output channel.*)
val std_out = open_out "";
fun prs s = output(std_out,s);
fun writeln s = prs (s ^ "\n");

use "library.ML";
use "term.ML";
use "symtab.ML";
use "queue.ML";
use "pretty.ML";

(*should belong to Pure???*)
print_depth 0;  
structure Symtab = SymtabFun();
structure Queue = QueueFun();
structure Pretty = PrettyFun(Queue);

cd "EARLEY";
use "ROOT.ML";
cd "..";

print_depth 1;  
use "sign.ML";
use "sequence.ML";
use "envir.ML";
use "unify.ML";
use "logic.ML";
use "thm.ML";
use "stringtree.ML";
use "tctical.ML";
use "tactic.ML";
use "conv.ML";
use "goals.ML";

use "pure.ML";		(*combines sign up to goals*)

use "simp.ML";		(*simplifier functor: used in object logics*)

(*Will be shared by all object-logics.*)
structure Pure = PureFun();
