(*  Title: 	LK/set/ruleshell
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Rules for Zermelo-Fraenkel Set Theory 

After updating, rebuild  "rules.ML"  by calling   "make-rulenames"   
*)

signature SET_RULE =
  sig
  structure Set_Syntax: SET_SYNTAX and Pure: PURE
	sharing Set_Syntax.Syntax = Pure.Sign.Syntax
  val sign: Pure.Sign.sg
  val thy: Pure.theory
(*INSERT-RULESIG -- file produced by make-rulenames*)
  end;


functor Set_RuleFun (structure Set_Syntax: SET_SYNTAX and LK_Rule: LK_RULE
	sharing Set_Syntax.Syntax = LK_Rule.Pure.Sign.Syntax) : SET_RULE = 
struct
structure Set_Syntax = Set_Syntax;
structure Pure = LK_Rule.Pure;
local open Pure 
in  

val thy = enrich_theory LK_Rule.thy "set" 
   ([],  Set_Syntax.const_decs,  Set_Syntax.syn)

[
  (*Empty set: would like just  "a:0 == false", but what is false? *)
  ("null_left",  "$H, a : 0, $G |- $E"  ),

  ("equal_members",
   "[| $H |- $E, a=b, $F;  $H |- $E, b:A, $F |] ==> $H |- $E, a:A, $F"),

  (*Extensionality as a definition of equality*)
  ("ext_def",     "A=B  ==  A<=B & B<=A"),
  ("setcons_def", "a: (b::B)  ==  a=b | a:B"  ),

  ("Pair_def",    "<a,b>  ==  { {a}, {a,b} }"),
  ("subset_def",  "A<=B  ==  (ALL x. x:A --> x:B)"),
  ("Collect_def", "a: Collect(A,P)  ==  a:A & P(a)"  ),
  ("Pow_def",     "A: Pow(B)  ==  A<=B"  ),
  ("Replace_def", "c: Replace(f,B) == (EX a. a:B & c=f(a))"),
  ("Union_def",   "A: Union(C)  ==  (EX B. A:B  &  B:C)"  ),

  ("Un_def",    "a Un b   ==  Union({a,b})"),
  ("Inter_def", "Inter(C) ==  [ x || x: Union(C), ALL y. y:C --> x:y ]"),
  ("Int_def",   "a Int b  ==  [ x || x:a, x:b ]"),
  ("Diff_def",  "a-b      ==  [ x || x:a, ~(x:b) ]"),

  (*Axiom of Choice*)
  ("Choose",  "$H, A=0 |- $E, $F ==> $H |- $E, Choose(A) : A, $F"),

  (*Axiom of infinity: the set INF is nonempty and succ-closed*)
  ("succ_def", "succ(a)  ==  a Un {a}"),
  ("INF_right_0",    "$H |- $E, 0:INF, $F"  ),
  ("INF_right_succ",  "$H |- $E, a:INF --> succ(a):INF, $F"  ),

  (*Regularity via transfinite induction -- lazy I admit*)
  ("induction",
    "(!u. $H, ALL v. v:u --> P(v) |- $E, P(u), $F) ==> $H |- $E, P(a), $F" )
];

(*The signature of the theory*)
val sign = sign_of thy;
val ax = get_axiom thy;

(*INSERT-RULENAMES -- file produced by make-rulenames*)
end;
end;
