(*  Title: 	LK/set/ex/un-int
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989 University of Cambridge

Set Theory examples: Union, Intersection, Inclusion, etc.
    (Thanks to Philippe de Groote.)

by (step_tac [triv_pack, set_pack, ext_pack] 1);
by (set_step_tac 1);
by (setpc_step_tac 1);
by (setpc_tac 1);

WHY SO SLOW??  need something like filhyp_resolve_tac*)

(* The following examples prove that intersection and inclusion, 
   w.r.t. subset ordering, are the meet and join operations of a
   distributive lattice.                                          *)

goal Set_Rule.thy "|- A Int B <= A";
by (set_tac 1);
result();

goal Set_Rule.thy "|- A Int B <= B";
by (set_tac 1);
result();

goal Set_Rule.thy "C <= A, C <= B |- C <= A Int B";
by (set_tac 1);
result();

goal Set_Rule.thy "|- A <= A Un B";
by (set_tac 1);
result();

goal Set_Rule.thy "|- B <= A Un B";
by (set_tac 1);
result();

goal Set_Rule.thy "A <= C, B <= C |- A Un B <= C";
by (set_tac 1);
result();

(*absorptive laws of Int and Un *)

goal Set_Rule.thy "|- A Int A = A";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);
result();

goal Set_Rule.thy "|- A Un A = A";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);
result();


goal Set_Rule.thy "|- A-A = 0";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);
result();


(*commutative laws of Int and Un *)

goal Set_Rule.thy "|- A Int B  =  B Int A";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);
result();

goal Set_Rule.thy "|- A Un B  =  B Un A";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);
result();


(*associative laws of Int and Un *)

goal Set_Rule.thy "|- (A Int B) Int C  =  A Int (B Int C)";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);   (*3 secs*)
result();

goal Set_Rule.thy "|- (A Un B) Un C  =  A Un (B Un C)";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);   (*4 secs*)
result();


(*distributive laws of Int and Un *)

goal Set_Rule.thy "|- (A Int B) Un C  = (A Un C) Int (B Un C)";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);  (*5 secs*)
result();

goal Set_Rule.thy "|- (A Un B) Int C  = (A Int C) Un (B Int C)";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);  (*6 secs*)
result();

goal Set_Rule.thy "|- A Int B <= A Un B";
by (set_tac 1);
result();

goal Set_Rule.thy
 "|- (A Int B) Un (B Int C) Un (C Int A) = (A Un B) Int (B Un C) Int (C Un A)";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1);
(*33 secs*)
result();

goal Set_Rule.thy "|- A - (B Un C) = (A-B) Int (A-C)";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1); 
result();

goal Set_Rule.thy "|- A - (B Int C) = (A-B) Un (A-C)";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack] 1); 
result();

goal Set_Rule.thy "|- A<=B <-> A Un B = B";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack, LK_pack] 1);
result();

goal Set_Rule.thy "|- A<=B <-> A Int B = A";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack, LK_pack] 1);
result();

(*Halmos, page 16.*)
goal Set_Rule.thy "|- C<=A  <->  (A Int B) Un C = A Int (B Un C)";
by (repeat_goal_tac [triv_pack, set_pack, ext_pack, LK_pack] 1);
(*9 secs*)
result();


writeln"Reached end of file.";
