(*  Title: 	HOL/ex/un-int
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Class Theory examples: union, intersection, subset, etc.
    (With thanks to Philippe de Groote.)

size_of_state (topthm());
by (Class.onestep_tac 1);
by (Class.step_tac asms 1);
by (Class.comp_step_tac asms);
by (Class.comp_tac asms);
*)

(* The following examples prove that intersection and inclusion, 
   w.r.t. subset ordering, are the meet and join operations of a
   distributive lattice.                                          *)

val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool |] ==> subset(A, int(A,R,S), R)";
by (Class.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool |] ==> subset(A, int(A,R,S), S)";
by (Class.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool;  T: A->bool |] \
\    ==> subset(A, T, R) & subset(A, T, S) -->  subset(A, T, int(A,R,S))";
by (Class.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool |] ==> subset(A, R, un(A,R,S))";
by (Class.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool |] ==> subset(A, S, un(A,R,S))";
by (Class.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool;  T: A->bool |] \
\    ==>   subset(A, R, T) & subset(A, S, T) --> subset(A, un(A,R,S), T)";
by (Class.fast_tac asms 1);
result();



writeln"absorptive laws of int and un";

val asms =
goal HOL_Rule.thy
    "R: A->bool ==> int(A,R,R) = R : A->bool";
by (Class.fast_tac ([equal_intr]@asms) 1);
result();

val asms =
goal HOL_Rule.thy
    "R: A->bool ==> un(A,R,R) = R : A->bool";
by (Class.fast_tac ([equal_intr]@asms) 1);
result();


writeln"commutative laws of int and un";

val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool |] ==> int(A,R,S) = int(A,S,R) : A->bool";
by (Class.fast_tac ([equal_intr]@asms) 1);
result();

val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool |] ==> un(A,R,S) = un(A,S,R) : A->bool";
by (Class.fast_tac ([equal_intr]@asms) 1);
result();


writeln"associative laws of int and un";

val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool;  T: A->bool |] \
\    ==> int(A, int(A,R,S), T) = int(A, R, int(A, S, T)) : A->bool";
by (Class.fast_tac ([equal_intr]@asms) 1);
result();

val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool;  T: A->bool |]  \
\    ==> un(A, un(A,R,S), T) = un(A, R, un(A, S, T)) : A->bool";
by (Class.fast_tac ([equal_intr]@asms) 1);
result();


writeln"distributive laws of int and un";

val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool;  T: A->bool |]  \
\    ==> un(A, int(A,R,S), T)  = int(A, un(A,R,T), un(A,S,T)) : A->bool";
by (Class.fast_tac ([equal_intr]@asms) 1);
result();

val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool;  T: A->bool |]  \
\    ==> int(A, un(A,R,S), T) = un(A, int(A,R,T), int(A,S,T)) : A->bool";
by (Class.fast_tac ([equal_intr]@asms) 1);
result();


writeln"Other examples";

val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool |] ==> subset(A, int(A,R,S), un(A,R,S))";
by (Class.fast_tac asms 1);
result();


val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool;  T: A->bool |]  \
\    ==> un(A, un(A, int(A,R,S), int(A,S,T)),  int(A,T,R)) =  \
\        int(A, int(A, un(A,R,S), un(A,S,T)), un(A,T,R)) : A->bool";
by (Class.fast_tac ([equal_intr]@asms) 1);
result();


val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool |]  \
\    ==> subset(A, R, S) <-> (un(A,R,S) = S : A->bool)";
by (REPEAT (Class.step_tac ([equal_intr]@asms) 1
	ORELSE eresolve_tac [equal_elim] 1));
result();


val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool |]  \
\    ==> subset(A, R, S) <-> (int(A,R,S) = R : A->bool)";
by (REPEAT (Class.step_tac ([equal_intr]@asms) 1
	ORELSE eresolve_tac [equal_elim] 1));
result();


(*Halmos, page 16.*)
val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool;  T: A->bool |]  \
\    ==> subset(A, T, R)  <->  \
\        (un(A, int(A,R,S), T) = int(A, R, un(A,S,T)) : A->bool)";
by (REPEAT (Class.step_tac ([equal_intr]@asms) 1
	ORELSE eresolve_tac [equal_elim] 1));
result();


writeln"Powersets";

val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool |] ==> \
\    subset(A->bool, un(A->bool, pow(A,R), pow(A,S)), pow(A, un(A,R,S)))";
by (Class.fast_tac asms 1);
result();


val asms =
goal HOL_Rule.thy
    "[| R: A->bool;  S: A->bool |] ==> \
\    int(A->bool, pow(A,R), pow(A,S)) = pow(A, int(A,R,S)) : (A->bool)->bool";
by (Class.fast_tac ([equal_intr]@asms) 1);
result();



writeln"Reached end of file.";
