(*The partial recursive functions in ML*)

type ifn = int list -> int list;

(** projections *)

fun hl [] = []
  | hl (x::xs) = [x];

fun tl [] = [] : int list
  | tl (x::xs) = xs;

(*constant zero function*)
fun zer (xs: int list) = [0];

(*successor*)
fun suc [] = []
  | suc (x::xs) = [x+1];

(*concatenation of results -- for composition*)
infix %;
fun (f: ifn) % (g: ifn) = fn xs => (f xs) @ (g xs);

(*composition*)
infix o;
fun (f: ifn) o (g: ifn) = fn xs => f (g xs);


(*primitive recursion*)
fun pr (f: ifn, g: ifn) [] = []
  | pr (f, g) (x::xs) = 
	let fun h(y) = if y=0 then  f xs  else  g (y-1 :: xs @ h(y-1))
	in  h(x)  end;


(*minimization*)
fun mn (f: ifn) xs =
    let fun g(y) = if f(xs@[y]) = [0]  then  y  else g(y+1)
    in  [g 0]  end;


(*concatenation of a list of functions*)
fun apfs [f] = f
  | apfs (f::g::fs) = f % apfs(g::fs);

(*composition with a list of functions*)
infix oo;
fun f oo gs = f o apfs gs;

(*projection functions: accessing the nth element*)
fun arg 1 = hl
  | arg n = arg(n-1) o tl;

(*applying a function to permuted arguments*)
infix on;
fun f on ns = f o apfs(map arg ns);

val add = pr (hl, suc on [3]);
add[12,23];

val mult = pr (zer, add on [2,3]);
mult[12,20];

val pow = pr (suc o zer, mult on [2,3]) on [2,1];
pow[8,3];

val pred = pr (zer, hl);
pred[32];

val diff = pr(hl, pred on [3]) on [2,1];
diff[35,12];
diff[13,12];
diff[11,12];

(*Note:	m<n	iff	n-m = s(k)
	m<=n	iff	m-n=0*)

(*remaux[m',m,n,r] = if n-r=0 then r-n else r: subtract n if r too big*)
val remaux = pr(diff on [2,1], arg 3) oo [diff on [3,4], arg 3, arg 4];
remaux[14,15,3,15];  (*should be 12*)
remaux[14,15,5,3];  (*should be 3*)

(*   h[0,m,n] = m
     h[s(m'),m,n] = remaux[m',m,n,h[m',m,n]] *)
val rem =  pr(hl, remaux) on [1,1,2];
rem[20,3];
rem[2,3];
rem[33,5];
rem[21,7];
rem[26,8];
rem[123,20];


(*quoaux[m',m,n,q] = if s(q)*n-m=0 then s(q) else q: add 1 if q too small*)
val quoaux = pr(suc, arg 2) oo
	[diff oo [mult oo [suc on [4], arg 3],
		  arg 2],
	 arg 4];
quoaux[14,15,3,3];  (*should be 4*)
quoaux[14,15,3,4];  (*should be 5*)
quoaux[14,15,3,5];  (*should be 5*)

(*   h[0,m,n] = 0
     h[s(m'),m,n] = quoaux[m',m,n,h[m',m,n]] *)
val quo =  pr(zer, quoaux) on [1,1,2];
quo[20,3];
quo[2,3];
quo[33,5];
quo[21,7];
quo[26,8];






