signature MonoSequence =

(* GENERAL MONOMORPHIC CONSTANT SEQUENCES

   Created by:  Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk
   Date:        21 Feb 1989

   Maintenance: Author


   DESCRIPTION

   These functions form a general interface for one-dimensional constant
   monomorphic sequences, such as ByteVectors and BoolVectors.

   The design parallels that of the Sequence signature, but replaces
   occurrences of 'a T with T and deletes function arguments to
   the comparison functions.


   SEE ALSO

   Object, Sequence, RefSequenceToObject.

*)

sig
  include Object

  val stringSep: string -> string -> string ->
		 T -> string

  exception Sep of string * string * string * string

  val parseSepN: string -> string -> string ->
		 Nat -> string -> (T, T Option) Result

  val parseSep: string -> string -> string ->
                string -> (T, T Option) Result

  val parseN: Nat -> string -> (T, T Option) Result

  val parseSepN': string -> string -> string ->
                 Nat -> string list ->
                 (T * string list, T Option * string list) Result

  val parseSep': string -> string -> string ->
                 string list ->
                 (T * string list, T Option * string list) Result

  val parseN': Nat -> string list ->
               (T * string list, T Option * string list) Result

  val readSep: string -> string -> string -> InStream -> (T, T Option) Result

  val readSepN: string -> string -> string ->
		Nat -> InStream -> (T, T Option) Result

  val readN: Nat -> InStream -> (T, T Option) Result

end
