(*$RefSequenceToObject : RefSequence Object *)

functor RefSequenceToObject (

(* MAKE A MONOREFVECTOR

   Created by:  Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk
   Date:        22 Jan 1990

   Maintenance: Author


   DESCRIPTION

   A functor to make an Object from a Sequence of Objects (where the elements of
   the Sequence have (mono)type T and the resulting Object has type T list.


   NOTES

   This is provided so that one can have MonoVectors of Sequences.

*)

  structure RefSequence: RefSequence
  structure Object: Object
): Object =
struct

  val version = 0.1


(* TYPES *)

  type T = Object.T RefSequence.T


(* CONVERTORS *)

  val read   = RefSequence.read Object.read
  val parse' = RefSequence.parse' Object.parse'
  val parse  = RefSequence.parse Object.parse'
  val string = RefSequence.string Object.string


(* OBSERVERS *)

  val fixedWidth = false

  val eq = RefSequence.same
  val ne = RefSequence.different
  val lt = RefSequence.lt Object.lt
  val le = RefSequence.le Object.le
  val gt = RefSequence.gt Object.gt
  val ge = RefSequence.ge Object.ge
end
