structure RealObject: Object =

(* REALS

   Created by:	Dave Berry, LFCS, University of Edinburgh
		db@uk.ac.ed.lfcs
   Date:	3 Apr 1989

   Maintenance:	Author


   DESCRIPTION

   Standard functions on the built-in type "real".
*)

struct

  val version = 0.1


(* TYPES *)

  type T = real


(* CONVERTORS *)

  fun parse _ = raise General.NotImplemented "Real.parse"

  fun parse' _ = raise General.NotImplemented "Real.parse'"

  fun read _ = raise General.NotImplemented "Real.read"

  fun string _ = raise General.NotImplemented "Real.string"


(* OBSERVERS *)

  val fixedWidth = false

  fun lt x y = (x: real) < y

  fun gt x y = (x: real) > y

  fun le x y = (x: real) <= y

  fun ge x y = (x: real) >= y

  fun eq x y = (x: real) = y

  fun ne x y = (x: real) <> y

end
