(*$Pair : List' StringType InStreamType *)

loadSig "Pair";

structure Pair: Pair =

(* TITLE

   Created by:	Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk

   Date:	1 Nov 1989

   Maintenance:	Author


   SEE ALSO

   ListPair
*)

struct

  val version = 0.1


(* CREATORS *)

  fun create x y = (x, y)


(* MANIPULATORS *)

  fun swap (x, y) = (y, x)

  fun apply f (x, y) = (f x, f y)

  fun applyPair (f, g) (x, y) = (f x, g y)

  fun tee (f, g) x = (f x, g x)

  fun binary f (x1, y1) (x2, y2) = (f x1 x2, f y1 y2)

  fun binaryPair (f, g) (x1, y1) (x2, y2) = (f x1 x2, g y1 y2)

(* CONVERTERS *)

  fun string p1 p2 (x, y) = "(" ^ p1 x ^ ", " ^ p2 y ^ ")"

  fun parse' p1 p2 l =
	let val ("("::t) = List'.dropPrefix (not o StringType.isVisible) l
	    val (OK (x, l)) = p1 t
	    val (","::t) = List'.dropPrefix (not o StringType.isVisible) l
	    val (OK (y, l)) = p2 t
	    val (")"::t) = List'.dropPrefix (not o StringType.isVisible) l
	in OK ((x, y), t)
	end
	handle Bind => Fail ()
       
  fun parse p1 p2 s =
	case 
	  parse' p1 p2 (explode s)
	of OK (p, s') => OK p
	|  Fail () => Fail ()

  fun read p1 p2 i =
	let
	  val "(" = (InStream.skip (not o StringType.isVisible) i;
		     InStream.input1 i)
	  val (OK x) = p1 i
	  val "," = (InStream.skip (not o StringType.isVisible) i;
		     InStream.input1 i)
	  val (OK y) = p2 i
	  val ")" = (InStream.skip (not o StringType.isVisible) i;
		     InStream.input1 i)
	in OK (x, y)
	end
	handle Bind => Fail ()
end

