(*$Int : Object StringType List' InStreamType *)

loadSig "Int";
loadStr "IntObject";

structure Int: Int =

(* INTEGERS

   Created by:	Dave Berry LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:	22 Sep 1989

   Maintenance:	Author
*)

struct

  val version = 0.1


(* PERVASIVES *)

  (* We implement the pervasives as they "should" be: *)

  exception Overflow
  and Div

  val op + =
	fn (x: int, y) =>
	  x + y
	  handle Plus => raise Overflow
  val op - =
	fn (x: int, y) =>
	  x - y
	  handle Sub => raise Overflow
  val op * =
	fn (x: int, y) =>
	  x * y
	  handle Prod => raise Overflow
  val op div =
	fn (x: int, 0) =>
	  raise Div
	|  (x: int, y) =>
	  x div y
	  handle OldDiv => raise Overflow
  val op mod =
	fn (x: int, 0) =>
	  raise Div
	|  (x: int, y) =>
	  x mod y
  val ~ =
	fn (x: int) =>
	  ~ x
	  handle Neg => raise Overflow
  val abs =
	fn (x: int) =>
	  abs x
	  handle Abs => raise Overflow

  val real = real


(* SYSTEM *)

  val minInt = Some ~4096

  val maxInt = Some 4095


(* OBJECT *)

  structure Object = IntObject
  open Object;


(* MANIPULATORS *)

  infix 7 divMod
  fun x divMod y = (x div y, x mod y)

  infix 7 quot rem quotRem
  fun x quot y =
    (case (x < 0, y < 0)
     of (true, true) => x div y
     |  (true, false) => ~(x div ~y)
     |  (false, true) => ~(~x div y)
     |  (false, false) => ~x div ~y
    )

  fun x rem y =
    x - y * (x quot y)

  fun x quotRem y = (x quot y, x rem y)

  fun max x y: int = if x > y then x else y

  fun min x y: int = if x < y then x else y

  fun maxMin x y: int * int = if x < y then (y, x) else (x, y)

  infix 5 --
  fun x -- y = if x > y then nil
  		else x :: (x + 1 -- y)

  infix 8 **
  exception **! of int * int
  fun x ** 0 = 1
  |   x ** 1 = x
  |   x ** 2 = x * x
  |   x ** n =
    if n < 0 then raise **! (x, n)
    else
      let val f = if n mod 2 = 0 then 1 else x
      in ((x ** (n div 2)) ** 2) * f
      end
    handle
      Prod => raise **! (x, n)
end
