(*$Int : Object StringType List' InStreamType *)

loadSig "Int";
loadStr "IntObject";

structure Int: Int =

(* INTEGERS

   Created by:	Dave Berry LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:	22 Sep 1989

   Maintenance:	Author
*)

struct

  val version = 0.1


(* PERVASIVES *)

  (* We implement the pervasives as they "should" be: *)

  exception Overflow
  and Div = Div

  val op + = op + : int * int -> int
  val op - = op - : int * int -> int
  val op * = op * : int * int -> int
  val op div = op div : int * int -> int
  val op mod = op mod : int * int -> int
  val ~ = ~ : int -> int
  val abs = abs : int -> int

  val real = real


(* SYSTEM *)

  val minInt = None

  val maxInt = None


(* OBJECT *)

  structure Object = IntObject
  open Object;


(* MANIPULATORS *)

  infix 7 divMod
  fun x divMod y = (x div y, x mod y)

  infix 7 quot rem quotRem
  val op quot =
       PolyML.Alternative_Div_and_Mod.quot

  val op rem =
       PolyML.Alternative_Div_and_Mod.rem

  fun x quotRem y = (x quot y, x rem y)

  fun max x y: int = if x > y then x else y

  fun min x y: int = if x < y then x else y

  fun maxMin x y: int * int = if x < y then (y, x) else (x, y)

  infix 5 --
  fun x -- y = if x > y then nil
  		else x :: (x + 1 -- y)

  infix 8 **
  exception **! of int * int
  fun x ** 0 = 1
  |   x ** 1 = x
  |   x ** 2 = x * x
  |   x ** n =
    if n < 0 then raise **! (x, n)
    else
      let val f = if n mod 2 = 0 then 1 else x
      in ((x ** (n div 2)) ** 2) * f
      end
end
