
structure BoolObject: Object =

(* BOOLEANS

   Created by:	Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:	22 Sep 1989

   Maintenance: Author
*)

struct

  val version = 0.1


(* TYPES *)

  type T = bool


(* CONVERTERS *)

  fun string true = "true"
  |   string false = "false"

  fun parse' l =
        case (List'.dropPrefix (not o StringType.isVisible) l) of
          ["t","r","u","e"] => OK (true, [])
        | ("t"::"r"::"u"::"e"::(l as s::t)) =>
	    if StringType.isId s then Fail (None, []) else OK (true, l)
        | ["f","a","l","s","e"] => OK (false, [])
        | ("f"::"a"::"l"::"s"::"e"::(l as s::t)) =>
	    if StringType.isId s then Fail (None, []) else OK (false, l)
        | _ => Fail (None, [])		(* random value *)

  fun parse s =
	case parse' (explode s) of
	  OK (b, _) => OK b
	| Fail _ => Fail None

  fun read i =
	(InStream.skip (not o StringType.isVisible) i;
         case InStream.input1 i of
           "t" =>
	   ( case InStream.readString i "rue" of
	       OK () =>
		 if (not o StringType.isId) (InStream.lookahead i)
		 then OK true
		 else Fail None
	     | Fail _ => Fail None
	   )
         | "f" =>
	   ( case InStream.readString i "alse" of
	       OK () =>
		 if (not o StringType.isId) (InStream.lookahead i)
		 then OK false
		 else Fail None
	     | Fail _ => Fail None
	   )
         |  _  => Fail None
	)


(* OBSERVERS *)

  val fixedWidth = false

  fun eq x y = (x = y)

  fun ne x y = (x <> y)

  fun lt x y = raise General.NotImplemented "Bool.lt"

  fun le x y = raise General.NotImplemented "Bool.le"

  fun gt x y = raise General.NotImplemented "Bool.gt"

  fun ge x y = raise General.NotImplemented "Bool.ge"

end
