\begin{caml_primitive}
sys_latex_print_big_int : int * string * big_int * string -> unit
latex_print_big_int : big_int -> unit
latex_print_for_read_big_int : big_int -> unit
sys_print_beautiful_big_int : 'a * string * big_int * string -> unit
print_beautiful_big_int : big_int -> unit
\end{caml_primitive}
These special printing functions for \verb"big_int"s cna be found into
two libraries: 
\begin{description}
\item[format\_latex\_numbers.ml: ] functions that split numbers into
small lines so \LaTeX \, is able to handle them correctly, 
\item[format\_numbers.ml: ] functions to present the \verb"big_int" as
a numerical table according to common conventions.
\end{description}

\verb"sys_latex_print_big_int (base, before, bi, after)" prints 
\verb"base" representation of the \verb"big_int" \verb"bi" between
\verb"before" and \verb"after", cutting line each \verb"latex_margin"
characters. 

\verb"latex_print_big_int" and \verb"latex_print_for_read_big_int" are 
equivalent to:
\begin{small}
\begin{verbatim}
let latex_print_big_int bi = 
  sys_latex_print_big_int (#10, "", bi, "")

and latex_print_for_read_big_int bi = 
  sys_latex_print_big_int (#10, "#(", bi, ")")
;;
\end{verbatim}
\end{small}
As an example this manual uses \verb"latex_print_for_read_big_int" as the 
printer for \verb"big_int"s.

\verb"sys_print_beautiful_big_int (base, before, bi, after)" prints 
\verb"base"-radix representation of the \verb"big_int" \verb"bi"
between \verb"before" and \verb"after" as a numerical table according
to classical conventions. 

\verb"print_beautiful_big_int" is equivalent to:
\begin{small}
\begin{verbatim}
let print_beautiful_big_int bi = 
  sys_print_beautiful_big_int (#10, "", bi, "")
;;
\end{verbatim}
\end{small}

You can load the libraries with:
\begin{small}
\begin{verbatim}
load_lib_file "format_latex_numbers";;
load_lib_file "format_numbers";;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#print_beautiful_big_int #(1e312);;
10000 00000  00000 00000  00000 00000  00000 00000  00000 00000
00000 00000  00000 00000  00000 00000  00000 00000  00000 00000
00000 00000  00000 00000  00000 00000  00000 00000  00000 00000
00000 00000  00000 00000  00000 00000  00000 00000  00000 00000
00000 00000  00000 00000  00000 00000  00000 00000  00000 00000

00000 00000  00000 00000  00000 00000  00000 00000  00000 00000
00000 00000  000
() : unit
\end{verbatim}
\end{small}
