\conceptindex{\verb"#"}
\conceptindex{coercion between types \verb"float" and \verb"string"}
\begin{caml_primitive}
sys_float_of_string : int * string * int * int -> float
float_of_string : string -> float
\end{caml_primitive}

CAML is able to read floating point numbers entered directly, following the 
lexical
convention:

\begin{small}
\begin{verbatim}
FLOAT ::= '#' {'-' | '+'} Digit+ '.' Digit+ {'e' {'-' | '+'} Digit+}
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
##1.0;;
1.0 : float

##1.0e2;;
100.0 : float

##1.0e-1;;
0.09999999 : float

##1.2e+2;;
120.0 : float

##-1.2e+2;;
-120.0 : float

##+1.2e+2;;
120.0 : float
\end{verbatim}
\end{small}

Using standard arithmetic, the sharp character is optional (see chapter 
~\ref{numdir} for more information).

\verb"sys_float_of_string (base, s, off, len)" maps the substring 
$s_{off, len}$ in base \verb"base" ($ 2 \leq \verb"base" \leq 16$) onto a 
floating point number.

\verb"float_of_string s" is semantically equivalent to:
\begin{small}
\begin{verbatim}
let float_of_string s = 
  sys_float_of_string (#10, s, #0, length_string s)
;;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#sys_float_of_string (#10, "123e-42", #0, #6);;
0.0123 : float

#float_of_string "123e-4";;
0.0123 : float
\end{verbatim}
\end{small}
