\begin{caml_primitive}
string_of_int : int -> string
string_for_read_of_int : int -> string
sys_string_of_int : int * string * int * string -> string
display_int : int -> unit
print_int : int -> unit
print_int_for_read : int -> unit
\end{caml_primitive}
\conceptindex{coercion between types \verb"int" and \verb"string"}
\conceptindex{\verb"print"}
\conceptindex{printing}

\verb"sys_string_of_int (b, before, i, after)" writes into the resulting 
string first the string \verb"before", then the representation of \verb"i" in 
base \verb"b", and lastly the string \verb"after".

\verb"string_of_int" is semantically equivalent to:
\begin{small}
\begin{verbatim}
let string_of_int i = sys_string_of_int (#10, "", i, "");;
\end{verbatim}
\end{small}

\verb"string_for_read_of_int" maps elements of type \verb"int" onto 
corresponding elements of type \verb"string" as well as \verb"string_of_int", 
but the sharp character \verb"#" is added before the number according to the 
lexical convention for numbers of type \verb"int". 

This function is semantically equivalent to:
\begin{small}
\begin{verbatim}
let string_for_read_of_int i = sys_string_of_int (#10, "#", i, "");;
\end{verbatim}
\end{small}
\verb"display_int" prints in a trivial way (i.e. without formatting its 
argument) numbers of type \protect\verb"int".

\verb"print_int" is the formatting function for numbers of type
\protect\verb"int". 

\verb"print_int_for_read" prints numbers of type \protect\verb"int"
such that they are readable by the CAML system.

On the one hand, \verb"display_int" and \verb"print_int" print numbers of
type \protect\verb"int" without printing sharp character \verb"#". On
the other hand, \verb"print_int_for_read" prints numbers of type
\protect\verb"int" with a sharp character \verb"#". 

For more details on the differences between \verb"display"- and \verb"print"- 
and \verb"print_*_for_read"-like functions see chapter ``Formatting
Functions'' in the reference manual. 

\exple
\begin{small}
\begin{verbatim}
#sys_string_of_int (#2, "begin ", #20, " end");;
"begin 10100 end" : string

#sys_string_of_int (#16, "hello ", #20, " world");;
"hello 14 world" : string

#string_of_int #12345;;
"12345" : string

#string_for_read_of_int #12345;;
"#12345" : string

#print_int #10;;
10() : unit

#print_int_for_read #10;;
#10() : unit
\end{verbatim}
\end{small}
