\conceptindex{coercion between types \verb"int" and \verb"char"}
\begin{caml_primitive}
int_of_char : char -> int
char_of_int : int -> char
\end{caml_primitive}

\verb"int_of_char c" is the ASCII code for \verb"c".

\verb"char_of_int i" is the character with ASCII code \verb"i".

The two following relations hold for each \verb"i" from type \verb"int" and 
each \verb"c" from type \verb"char" :
\begin{eqnarray*}
int\_of\_char\, (char\_of\_int\: i) = i\\
char\_of\_int\, (int\_of\_char\: c) = c
\end{eqnarray*}

\exple
\begin{small}
\begin{verbatim}
#char_of_int #49;;
`1` : char

#int_of_char `1`;;
49 : int
\end{verbatim}
\end{small}
