\begin{caml_primitive}
int_of_ratio : ratio -> int
ratio_of_int : int -> ratio
\end{caml_primitive}
\conceptindex{coercion between types \verb"int" and \verb"ratio"}
\conceptindex{\verb"is_integer_ratio"}

\verb"int_of_ratio r" is the \verb"int" representing the rational number
\verb"r" if \verb"r" fits in an \verb"int", otherwise
\verb"int_of_ratio" fails. 

\verb"ratio_of_int" maps naturally an \verb"int" onto the corresponding 
\verb"ratio".

\exple
\begin{small}
\begin{verbatim}
#int_of_ratio #[1.2e3];;
1200 : int

#int_of_ratio (add_int_ratio (#1, ratio_of_int biggest_int));;

Evaluation Failed: failure "int_of_ratio"

#int_of_ratio (add_int_ratio (#-1, ratio_of_int least_int));;
-32768 : int

#ratio_of_int #1;;
#[1/1] : ratio
\end{verbatim}
\end{small}
