\begin{caml_primitive}
add_int : int * int -> int
minus_int : int -> int
sub_int : int * int -> int
mult_int : int * int -> int
quo_int : int * int -> int
mod_int : int * int -> int
gcd_int : int * int -> int
\end{caml_primitive}
\conceptindex{\verb"+"}
\conceptindex{\verb"-"}
\conceptindex{\verb"*"}
\conceptindex{\verb"/"}
\conceptindex{\verb"gcd"}
\conceptindex{\verb"monster_int"}

\verb"add_int", \verb"sub_int", \verb"mult_int" perform respectively the 
addition, subtraction and multiplication on numbers of type \protect\verb"int".

\verb"minus_int x" is the opposite of \verb"x". We have :
$$
minus\_int monster\_int = monster\_int.
$$
%minus_int monster_int = monster_int.

For division on numbers of type \protect\verb"int", \verb"quo_int (x, y)" and 
\verb"mod_int (x, y)" are respectively the quotient and the remainder of the 
Euclidian division of \verb"x" by \verb"y". 

\begin{beware}
\item In fact, in case of a negative argument, \verb"quo_int (x, y)" is one 
more greater than the result of Euclidian division (i.e. each partial 
function of \verb"quo_int" is an odd function) and \verb"mod_int" doesn't 
always produce positive integers.
\end{beware}

\verb"gcd_int (n1, n2)" computes the gcd of the two numbers of type 
\protect\verb"int" \verb"n1" and \verb"n2". We have the following
relation:
$$
gcd\_int (n_1, n_2) = gcd\_int (|n_1|, |n_2|) = gcd\_int (n_2, n_1) \leq 0
$$
%            gcd_int (n1, n2) = gcd_int (n1, n2) = gcd_int (n2, n1)>= 0
\bigskip

\exple
\begin{small}
\begin{verbatim}
#add_int (#43, #-12);;
31 : int

#minus_int biggest_int;;
-32767 : int

#minus_int least_int;;
32767 : int

#minus_int monster_int;;
-32768 : int

#mult_int (biggest_int, #2);;
-2 : int

#quo_int (#123, #3);;
41 : int

#mod_int (#123, #3);;
0 : int

#quo_int (#123, #-3);;
-41 : int

#mod_int (#123, #-3);;
0 : int

#quo_int (#123, #4);;
30 : int

#mod_int (#123, #4);;
3 : int

#quo_int (#123, #-4);;
-30 : int

#mod_int (#123, #-4);;
3 : int

#gcd_int (#4, #6);;
2 : int

#gcd_int (#2, #3);;
1 : int

#gcd_int (#-6, #4);;
2 : int
\end{verbatim}
\end{small}

Notice that these arithmetic operations do not check for overflow.

Using type \verb"num", a careful (but less efficient) version of 
multiplication may be defined as in:
\begin{small}
\begin{verbatim}
#let mult_int_care (x, y) =
# match mult_num (Int x, Int y)
# with Int result -> result
#   |      _      -> failwith "overflow"
#;;
Value mult_int_care is <fun> : int * int -> int

#mult_int_care(biggest_int,#2);;

Evaluation Failed: failure "overflow"
\end{verbatim}
\end{small}
