load "escher_basic_pictures";;

echo_values false;;

let [P;Q;R;S] = map hflip_sketch  [skp;skq;skr;sks];;

let rot = rotate_sketch 90;;
let small = scale_sketch (0.5,0.5);;

let trio(p1,p2,p3) =
   (p1 BSK p2) OSK p3;;

let quartet (p1,p2,p3,p4) =
    (p1 BSK p2) OSK (p3 BSK p4);;

let cycle p =
    (p BSK (rot (rot (rot p)))) 
    OSK 
    ((rot p) BSK (rot(rot p)));;



let T =quartet(P,Q,R,S);;

let U = cycle (rot Q);;

let C0=U and L0 = rot T and T0=T;;

let C1= quartet(small C0,small(L0 BSK T0)
               ,small((rot T0)OSK(rot L0)), U)
and L1 = trio(small L0,small T0,rot T)
and T1 = trio(small L0,small T0, T);;

let C2= quartet(small C1,small (L1 BSK T1)
               ,small((rot T1)OSK(rot L1)), U)
and L2 = trio(small L1,small T1,rot T)
and T2 = trio(small L1,small T1, T);;

let corner= quartet(small C2,small L2,
                    small(rot T2),rot Q);;

let SL = cycle corner;;



echo_values true;;
