(* $Id: image.ml,v 8.2 91/06/19 19:43:46 ddr Exp $
 *
 * Rogloglo Toolkit: images
 *
 * $Log:	image.ml,v $
 * Revision 8.2  91/06/19  19:43:46  ddr
 * - merge avec zinc 1.3
 * 
 * Revision 8.1  91/06/15  10:27:33  ddr
 * - merge avec zinc
 * 
 *)

#standard arith false;;
#fast arith false;;

(* should be set in the C part *)
let XCreateEmptyImage(a,b,c,d,e,f,g,h,i) = XCreateImage(a,b,c,d,e,"",f,g,h,i);;
let XPutImageWithData(a,b,c,ximage,im_data,f,g,h,i,j,k) =
  set_XImage_data(im_data, ximage);
  (* If a GC is triggered here, it may move the string elsewhere *)
  XPutImage(a,b,c,ximage,f,g,h,i,j,k)
;;
(* end *)

type image = {
  ximage      : XImage;
  im_data     : string
}
;;

let rt_create_image(xd, data, width, height, depth) =
  let xdm = xd.xdm in
  let image = XCreateEmptyImage(
    xdm.dpy, xdm.vis, CINT depth,
    (if depth = 1 then XYBitmap else ZPixmap), Zero_Int,
    CINT width, CINT height, CINT 8, Zero_Int
  ) in
  set_XImage_bitmap_bit_order(LSBFirst, image);
  set_XImage_byte_order(LSBFirst, image);
  xdm.end_func <- (function () ->
    free_XImage image;
    ()
  ) :: xdm.end_func;
  {ximage = image; im_data = data}
;;

let rt_put_image(draw, image, s_x, s_y, d_x, d_y, width, height) =
  let ximage = image.ximage and im_data = image.im_data in
  let xdm, draw = match draw with
    C'WidgetDr wid -> wid.wid_xd.xdm, wid.win
  | C'PixmapDr pixm -> pixm.pixm_xdm, pixm.pixmap in
  XPutImageWithData(xdm.dpy, draw, xdm.gc, ximage, im_data,
    CINT s_x, CINT s_y,
    CINT d_x, CINT d_y, CINT width, CINT height
  );
  ()
;;
