(* $Id: ddr_ext.ml,v 8.1 91/06/20 14:46:13 ddr Exp $
 *
 * $Log:	ddr_ext.ml,v $
 * Revision 8.1  91/06/20  14:46:13  ddr
 * - distrib
 * 
 * Revision 7.1  91/05/28  20:51:18  ddr
 * - distrib
 * 
 * Revision 6.2  91/05/27  11:01:24  ddr
 * - sockets
 * 
 * Revision 6.1  91/04/22  14:48:48  ddr
 * - distrib
 *)

#standard arith false;;
#fast arith false;;
external_address_cache true;;

let MinusOne_Int = C_Int(address_of_num(-1));;

(*
def_C_fun("free_fd_set", <:Caml:Type<fd_set -> C_Void>>);;
*)
def_C_fun("FD_ZERO", <:Caml:Type<fd_set -> C_Void>>);;
def_C_fun("FD_SET", <:Caml:Type<C_Int * fd_set -> C_Void>>);;
def_C_fun("FD_ISSET", <:Caml:Type<C_Int * fd_set -> C_Int>>);;
def_C_fun("fselect", <:Caml:Type<C_Int * fd_set * C_Long -> C_Int>>);;

#pragma let def_C_fun (fname, ftype) =
	define_external_function(fname, ftype, ("_ML_" ^ fname))
;;

let patch_C_fun(name, mlt) =
  define_external_function(name, mlt, "_patch_ML_" ^ name)
;;

patch_C_fun("alloc_XPoint", <:Caml:Type<C_Int -> XPoint>>);;
patch_C_fun("set_XPoint_x", <:Caml:Type<C_Short * XPoint * C_Int -> C_Void>>);;
patch_C_fun("set_XPoint_y", <:Caml:Type<C_Short * XPoint * C_Int -> C_Void>>);;
patch_C_fun("XPoint_x", <:Caml:Type<XPoint * C_Int -> C_Short>>);;
patch_C_fun("XPoint_y", <:Caml:Type<XPoint * C_Int -> C_Short>>);;

(* files *)

type file_desc = 'FileDesc of C_Int;;

#directive define_external_function(
  "file_open", <:Caml:Type<string * C_Int -> C_Int>>, "_open"
);;
let file_open path flag =
  let fd = file_open(path, CINT flag) in
  if fd = MinusOne_Int then failwith "file_open"
  else 'FileDesc fd
;;

#directive define_external_function(
  "file_read", <:Caml:Type<C_Int * string * C_Int -> C_Int>>, "_read"
);;
let file_read ('FileDesc s) str =
  let len = num_of_C_Int(file_read(s, str, CINT(length_string str))) in
  if len < 0 then failwith "file_read" else len
;;

#directive define_external_function(
  "file_write", <:Caml:Type<C_Int * string * C_Int -> C_Int>>, "_write"
);;
let file_write ('FileDesc s) str len =
  let len = num_of_C_Int(file_write(s, str, CINT len)) in
  if len < 0 then failwith "file_write" else len
;;

#directive define_external_function(
  "file_close", <:Caml:Type<C_Int -> C_Void>>, "_close"
);;
let file_close ('FileDesc s) = file_close s; ()
;;

#directive define_external_function(
  "file_creat", <:Caml:Type<string * C_Int -> C_Int>>, "_creat"
);;
let file_creat path mode =
  let fd = file_creat(path, CINT mode) in
  if fd = MinusOne_Int then failwith "file_creat"
  else 'FileDesc fd
;;

let file_number ('FileDesc s) = (num_of_C_Int s);;


(* sockets *)

#directive define_external_function(
  "socket_server", <:Caml:Type<C_Int -> C_Int>>, "_ML_socket_server"
);;
#directive define_external_function(
  "socket_client", <:Caml:Type<string * C_Int -> C_Int>>, "_ML_socket_client"
);;

let socket_server p = 'FileDesc(socket_server(CINT p));;
let socket_client h p = 'FileDesc(socket_client(h, CINT p));;

external_address_cache false;;
