#!/bin/sh
#************************************************************************
#
#			Projet     Formel
#
#			    ML in ML
#
#*************************************************************************
#
#            			Inria
#			Domaine de Voluceau
#			78150  Rocquencourt
#				France
#
#*************************************************************************
#
# camlyacc.sh	Extracts yacc tables and actions from yacc output.
#
/bin/ed - y.tab.c <<FINI
1,/^# *line/d
/^(\* Caml part \*)\$/;\$d
g/# *define */d
1i

directive open_env "$1";;

(* BEGINNING OF LEXICALS *)

let syntax_name = "$1";;
.
/let current_syntax/d
1,\$p
E y.tab.c
1,/int yyexca/-d
/typedef struct/,\$d
g/int/s//let /
g/\[\].*/s// = [|/
g/,/s//;/g
g/};/s//|];;/
g/# *define/s/# *define *\([A-Z]*\)/let \1 =/\\
s/\$/;;/
/let  yychk =/i
modify_vect
 (function n ->
  unchecked_coercion (
   quo_int
    (sub_int (unchecked_coercion n,(mod_int (unchecked_coercion n,#2))),
     #2)))
 yyr2;;
.
?let YYNPROD = ?-2s/;\$//
1i

(* BEGINNING OF TABLES *)

.
\$a

(* END OF TABLES *)
.
1,\$p
E y.tab.c
1,/switch( yytmp )/d
1d
/goto yystack;/-,\$d
g/^case /s/case /vect_assign($1_yyact_vect, /\\
s/:/, (fun () -> /
g/^# line/s/^# line/(* action line/\\
s/\$/ *)/
g/^{/s//Repr (/
g/} break;/s//)));;/
g/yypvt\[-\([0-9]*\)\]/s//(peek_val \1)/g
1i

let $1_yytabs =
    (yyexca,yyact,yypact,yypgo,yyr1,yyr2,yychk,yydef);;

(* BEGINNING OF ACTIONS *)

let $1_yyact_vect = vector (YYNPROD+1) of (fun () -> !yy_val);;
.
\$a

let $1_yyactions n = vect_item($1_yyact_vect, n) ();;

(* END OF ACTIONS *)

let $1_lsyntax =
 ($1_strings,$1_double,
  ($1_NUM,$1_INT,$1_FLOAT,$1_IDENT,$1_BOOL,$1_STRING,$1_INFIX,$1_CHAR,$1_EOF,
   $1_BIGINT,$1_RATIO,$1_DYN),
  ($1_strdelim,$1_cmndelim),
  $1_sub_syntaxes)
;;

let $1_psyntax = ($1_yyactions,$1_yytabs,YYLAST);;

let $1_syntax = CAML_system_make_Syntax
                 ("$1",$1_syntax_flag,$1_lsyntax,$1_psyntax);;

(* syntax_flag = (yy_)lex; syntax_type = syntax/value *)

add_syntax (make_parser $1_syntax_type  $1_syntax);();;

.
1,\$p
E y.tab.c
1,/^(\* Caml part \*)\$/-d
/int yyexca/,\$d
1,\$p
Q
FINI
