#set default grammar CAML;;

(* Syntaxe superficielle des lambda-expressions *)
type Slambda =
     SVar of string
   | SApply of Slambda * Slambda
   | SLambda of (string * string list) * Slambda
 within
  {Start:num;End:num}
;;

(* With CAML grammar :
mlet make_syntax e =
 <<#e within {Start = symbol_start(); End = symbol_end()}>>
;;


#set default grammar CAML;;

(* Grammaire des lambda-expressions *)
grammar for values lambda =

 rule

exp0 = parse
    Ident s -> #(make_syntax <<SVar s>>)
  | [ "("; exp e; ")" ] -> e

and app = parse
          [<hov 1> app e ; \-; exp0 e0 ] ->
          #(make_syntax <<SApply (e,e0)>>)
        | exp0 e -> e

(*and entry foo = parse exp e accept e*)

and entry exp = parse
      [<hov 1> "\\"; Ident s; ( * (parse \-; Ident s -> s)) sl;
                     "."; \- ; exp e ] ->
        #(make_syntax <<SLambda ((s,sl),e)>>)
    | app e -> e
;;
*)

(* With lex macros *)
#pragma let annotations =
 " within {Start = symbol_start(); End = symbol_end()}"
;;

(* Grammaire des lambda-expressions *)
grammar for values lambda =

 rule

exp0 = parse
    Ident s -> SVar s ##annotations
  | [ "("; exp e; ")" ] -> e

and app = parse
          [<hov 1> app e ; \-; exp0 e0 ] -> SApply (e,e0) ##annotations
        | exp0 e -> e

and entry exp = parse
      [<hov 1> "\\"; Ident s; ( * (parse \-; Ident s -> s)) sl;
                     "."; \- ; exp e ] -> SLambda ((s,sl),e) ##annotations
    | app e -> e
;;

let f = function
  SVar s as lam -> print_num lam.End

| SLambda ((s,sl),lam) -> print_num lam.End

| SApply (lam1,lam2) -> print_num lam1.Start;print_num lam2.End
;;

