(progn
 (exchstring (inbuf) (makestring 2048 32))
 (exchstring (outbuf) (makestring 1024 32))
 ()
)

(libload module t)
(loadmodule 'loader)
(typefn 'loader)

(loadfile "../llobj/io_patch.lo" t)
(load-cpl ()   ; le core
          ()   ; env mini
          ()   ; edit
          ()   ; env moy
          t    ; chargeur
          ()   ; compilo
)

;(loadmodule "operand")
(synonymq #:system:bcode #:system:ccode)
(synonymq checkstk identity)
(setq %bcode (subadr (#:system:ccode) '1))

(loadmodule "genarith")
(loadmodule "genr")
(loadmodule "ratiov")
(loadmodule "callext")

(load "../llobj/camload.lo")

(loader '((fentry ml_newer subr2)
          (entry ml_newer subr2)
          (push (eval (kwote (getglobal '_newer))))
          (push '1)
          (push a1)
          (push '3)
          (push a2)
          (push '3)
          (mov '6 a4)
          (jmp callextern)
          (endl)))


(ifn (typefn 'ml_protect)
     (loader '((fentry ml_protect subr2)
               (bri a2)
               (endl))))

;(ifn (typefn 'gctime)
;     (loader '((fentry gctime subr0)
;               (mov '0 a1) (return)
;               (endl))))

(ifn (typefn 'cons-count)
     (loader '((fentry cons-count subr0)
               (mov '0 a1) (return)
               (endl))))

(defmacro failwith (s)
    `(raise ,(if (stringp s) `'(7 . ,s)
                     `(cons 7 ,s))))

(defmacro io_failwith (s) `(raise (cons ml_io_failure
                            ,(cond ((symbolp s) (string (symeval s)))
                                   (t s)))))

(setq #:system:read-case-flag t)
;(setq  #:system:real-terminal-flag () )
(setq #:sys-package:itsoft ())
(defvar #:system:print-msgs 0)  ; Pour ne pas etre trop bavard

(de init-camlisp (msg)
    (print msg)
    ()
)

(loadmodule 'defstruct)
(loadmodule 'display)
(loadmodule 'virbitmap)
(loadmodule 'date)

(de caml-core-init (msg)
    ; rea'lise la se'quence d'initialisation apre`s un restore-core.
    ; msg est le message de bienvenue.
    (when #:system:initty-after-restore-flag 
          (initty))
    (when #:system:inibitmap-after-restore-flag 
          (inibitmap))
    ()
)

(add-feature (if (eq 0.0 0.0)
                 '31BITFLOATS
                 '64BITFLOTS))

(save-std #:system:name
          "Initial core image of the CAML system"
          'init-camlisp 'caml-core-init)

(gcinfo)
