/*******************************************************************

                 Les Fonctions Flottantes en C
                 utilisable sur tous les UNIX.

 *****************************************************************
   Ce fichier est en lecture seule hors du projet ALE de l'INRIA  
 Il est maintenu par : ILOG S.A. 9 rue Royale, 75008 Paris, France
 *****************************************************************

$Header: llfloat.c,v 5.10 90/02/15 00:01:58 kuczynsk Exp $

 *******************************************************************/

/*
  Les conditionnelles de compilation
  
  IBMRT   : l'IBM RT
  SUN4    : les SUN 4
  SUNOS40 : Les syste`mes UN*X  SUN OS 4.0
  MIPS    : les machines a' base de MIPS

*/

#include <signal.h>
#include <errno.h>
#include <math.h>

extern int errno;

#ifndef MIPS
/* Les accus flottants simples pre'cisions, obligatoires pour forcer le
   compilateur C a traiter la simple pre'cision (les parame`tres flottants
   sont toujours traite's en double pre'cision!).
   Il sont de'clare's dans <systeme>/ll<systeme>.llm3.               */
extern float accusingle1;
extern float accusingle2;
#endif MIPS

/********************/
/*  Les Conversions */
/********************/

/* Conversions flottants <--> ascii */
#ifdef MIPS
/*
 * gcvt  - Floating output conversion to
 * minimal length string
 */

char	*ecvt();

char *
gcvt(number, ndigit, buf)
double number;
char *buf;
{
	int sign, decpt;
	register char *p1, *p2;
	register i;

	p1 = ecvt(number, ndigit, &decpt, &sign);
	p2 = buf;
	if (sign)
		*p2++ = '-';
	/* Exceptional numbers */
	if (*p1 == 'I') { /* Infinity */
		strcpy(p2, "Infinity");
		return buf;
	} else if (*p1 == 'N') { /* Not a Number */
		strcpy(p2, "NaN");
		return buf;
	}
	/* remove trailing 0 */
	for (i=ndigit-1; i>0 && p1[i]=='0'; i--)
		ndigit--;
	if (decpt >= 0 && decpt-ndigit > 4
	 || decpt < 0 && decpt < -3) { /* use E-style */
		decpt--;
		*p2++ = *p1++;
		*p2++ = '.';
		for (i=1; i<ndigit; i++)
			*p2++ = *p1++;
		*p2++ = 'e';
		if (decpt<0) {
			decpt = -decpt;
			*p2++ = '-';
		} else
			*p2++ = '+';
		if (decpt >= 100) {
			*p2++ = decpt/100 + '0';
			decpt -= (decpt/100)*100;
		}
		*p2++ = decpt/10 + '0';
		*p2++ = decpt%10 + '0';
	} else { /* use F-style */
		if (decpt<=0) {
			if (*p1!='0')
				*p2++ = '.';
			while (decpt<0) {
				decpt++;
				*p2++ = '0';
			}
		}
		for (i=1; i<=ndigit; i++) {
			*p2++ = *p1++;
			if (i==decpt)
				*p2++ = '.';
		}
		if (ndigit<decpt) {
			while (ndigit++<decpt)
				*p2++ = '0';
			*p2++ = '.';
		}
	}
	/* don't remove trailing .
	if (p2[-1]=='.')
		p2--; */
	*p2 = '\0';
	return(buf);
}
#else MIPS
extern char *gcvt();
#endif MIPS

/* Conversion double flottant -> ascii */

int cvftoa(number, buffer) double number; char *buffer; {
char* depart;
int point;
	point = 0;
#ifdef SUNOS40
        depart = gconvert(number,12,0,buffer);
	if ( buffer[0] == '0' && 
	     buffer[1] == '.' &&
	     buffer[2] != '\0' ) {
		while (*buffer != '\0')
			*buffer=*(++buffer);
		point = 1;
	}
        else 
#else  SUNOS40
#if IBMRT || MACAUX || UNIGRAPH
        depart = buffer;
        sprintf(buffer,"%g",number);
#else  IBMRT || MACAUX || UNIGRAPH
	depart = gcvt(number, 12, buffer);
#endif IBMRT || MACAUX || UNIGRAPH
#endif SUNOS
	while(*buffer != '\0') {
	     if(*buffer == '.' || *buffer == 'e') {
		     point = 1;
		     while (*buffer != '\0' ) buffer++; 
	     }
	     else buffer++; 
        }
	if(point == 0){
	  *buffer++ = '.';
	  *buffer = '\0';
	}
	return(buffer - depart);
}

/* Conversion simple flottant ->  ascii */
#ifdef MIPS
int cvstoa(float number, char *buffer) {
	char* depart;

        depart = gcvt((double)number, 7, buffer);
	while(*buffer != '\0')
	    buffer++;
	return(buffer - depart);
}
#else MIPS
int cvstoa( buffer) char *buffer; {
char* depart;
int point;
	point = 0;
#ifdef SUNOS40
        depart = sgconvert(&accusingle1,7,0,buffer);
	if ( buffer[0] == '0' && 
	     buffer[1] == '.' &&
	     buffer[2] != '\0' ) {
		while (buffer[point] != '\0') {
			buffer[point]=buffer[point+1];
                        point++;
		}
                buffer=&buffer[point-1];
	}
        else 
#else  SUNOS40
#if IBMRT || MACAUX || UNIGRAPH
        depart = buffer;
        sprintf(buffer,"%g",accusingle1);
#else  IBMRT || MACAUX || UNIGRAPH
        depart = gcvt(accusingle1, 7, buffer);
#endif IBMRT || MACAUX || UNIGRAPH
#endif SUNOS40
#ifdef SONY
        while(*buffer != '\0')
		if(*buffer++ == '.')
			point = 1;
#else  SONY
	while(*buffer != '\0') {
	     if(*buffer == '.' || *buffer == 'e') {
		     point = 1;
		     while (*buffer != '\0' ) buffer++; 
	     }
	     else buffer++; 
        }
#endif SONY
	if(point == 0){
	  *buffer++ = '.';
	  *buffer = '\0';
	}
	return(buffer - depart);
}
#endif MIPS

#ifndef NEXT
extern double atof();
#endif NEXT

/* Conversion ascii -> double flottant */

double cvatof (buffer)
char *buffer;
{
	double foo;

	errno = 0;
	foo = atof(buffer);
/* the sun4 and SunOS4.0 have IEEE routines which routine Inf. */
#ifndef SUN4
#ifndef SUNOS40
	if (errno == ERANGE)
		kill (getpid(), SIGFPE);
#endif SUNOS40
#endif SUN4
	return(foo);
}

/* Conversion ascii -> simple flottant */
#ifdef MIPS
float cvatos (char *buffer) {
	double foo;

	errno = 0;
	foo = atof(buffer);
	if (errno == ERANGE)
		kill (getpid(), SIGFPE);
	return((float)foo);
}
#else MIPS
cvatos (buffer)
char *buffer;
{
	double foo;

	errno = 0;
	foo = atof(buffer);
/* the sun4 and SunOS4.0 have IEEE routines which routine Inf. */
#ifndef SUN4
#ifndef SUNOS40
	if (errno == ERANGE)
		kill (getpid(), SIGFPE);
#endif
#endif
	accusingle2=foo;
}
#endif MIPS

#ifdef MIPS
/* fpow (power simple precision) */

float fpow(float x, float y) {
    return (float)(pow((double)x , (double)y));
}
#else MIPS
/* Conversions doubles flottants <--> fixnums */

double floatc (n) int n;{
       return(n);
}

int fixc(f) double f;{
    return(f);
}

/* Convertions  simples flottants <--> fixnums */

sfloatc (n) int n; {
       accusingle2=n;
}

int sfixc() {
    return (accusingle1);
}

/* Conversions  simples flottants <--> doubles flottants */

dtosc (f) double f; {
      accusingle2=f;
}

double stodc () {
       return (accusingle1);
}

/***********************************/
/* Arithmetique doubles flottants  */
/* operations elementaires doubles */
/***********************************/

double fplus(f1, f2) double f1, f2; {
	return(f2 + f1);
}

double fdiff(f1, f2) double f1, f2; {
	return(f2 - f1);
}

double ftimes(f1, f2) double f1, f2; {
	return(f2 * f1);
}

double fquo(f1, f2) double f1, f2; {
	return(f2 / f1);
}

int cfbeq (f1, f2) double f1, f2; {
	return(f1 == f2);
}

int cfbne (f1, f2) double f1, f2; {
	return(f1 != f2);
}

int cfble (f1, f2) double f1, f2; {
	return(f1 <= f2);
}

int cfblt (f1, f2) double f1, f2; {
	return(f1 < f2);
}

int cfbge (f1, f2) double f1, f2; {
	return(f1 >= f2);
}

int cfbgt (f1, f2) double f1, f2; {
	return(f1 > f2);
}

/* Les fonctions circulaires et mathematiques doubles */

double fsin(f1) double f1; {
	return(sin(f1));
}

double fcos(f1) double f1; {
	return(cos(f1));
}

double fasin(f1) double f1; {
	return(asin(f1));
}

double facos(f1) double f1; {
	return(acos(f1));
}

double fatan(f1) double f1; {
	return(atan(f1));
}

double fexp(f1) double f1; {
	return(exp(f1));
}

double flog(f1) double f1; {
	return(log(f1));
}

double flog10(f1) double f1; {
	return(log10(f1));
}

double fpower(f1,f2) double f1, f2; {
	return(pow(f1,f2));
}

double fsqrt(f1) double f1; {
	return(sqrt(f1));
}

/********************************************/
/* Arithmetique simples flottants           */
/* operations elementaires simple precision */
/********************************************/

/* sens   accu2 op acc1 -> accu2 */

splus() {
	accusingle2=accusingle2+accusingle1;
}

sdiff() {
	accusingle2=accusingle2-accusingle1;
}


stimes() {
	accusingle2=accusingle2*accusingle1;
}

squo() {
	accusingle2=accusingle2/accusingle1;
}

int csbeq () {
	return(accusingle1 == accusingle2);
}

int csbne () {
	return(accusingle1 != accusingle2);
}

int csble () {
	return(accusingle1 <= accusingle2);
}

int csblt () {
	return(accusingle1 < accusingle2);
}

int csbge () {
	return(accusingle1 >= accusingle2);
}

int csbgt () {
	return(accusingle1 > accusingle2);
}


/* Les fonctions circulaires et mathematiques simple presicion */

ssin() {
	accusingle2=sin(accusingle1);
}

scos() {
	accusingle2=cos(accusingle1);
}

sasin() {
	accusingle2=asin(accusingle1);
}

sacos() {
	accusingle2=acos(accusingle1);
}

satan() {
	accusingle2=atan(accusingle1);
}

sexp() {
	accusingle2=exp(accusingle1);
}

slog() {
	accusingle2=log(accusingle1);
}

slog10() {
	accusingle2=log10(accusingle1);
}

spower() {
	accusingle2=pow(accusingle1,accusingle2);
}

ssqrt() {
	accusingle2=sqrt(accusingle1);
}

#endif MIPS
