(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* user_prelude.ml General purpose functions                             *)
(*                 These functions are defined autoload                  *)
(*                 in the CAML system                                    *)

(*\
\chapter{User's prelude}

This file contains a set of general purpose functions, which has not been
 included in the very prelude of the language since these functions are
 not so often used.

\section{Iterators}
\index{Iterators}
\begin{caml_primitive}
it_map
set_extension
it_pair_list
\end{caml_primitive}

\begin{itemize}
\item \verb"it_map f g b l" ``it\_lists'' \verb"f" on the result of the
mapping of \verb"g" on the list \verb"l":
\par\noindent
\verb"it_map f g b l = it_list f b (map g l)"
\par\noindent
\item \verb"set_extension f l" builds a set from the results obtained
by the application of \verb"f" to the elements of \verb"l"
 (\verb"f" is supposed to produce lists).
\item \verb"it_pair_list f (l1,l2)" \verb"it_list"s \verb"f" on the list
of pairs  obtained from elements of \verb"l1" and \verb"l2".
\end{itemize}

\*)
let it_map f g = it_map_f_g
 where rec it_map_f_g a = fun [] -> a | (b::l) -> (it_map_f_g (f a (g b)) l);;

(* set_extension = - : (('a -> 'b list) -> 'a list -> 'b list) *)
(*let set_extension f = it_list (fun l x -> union l (f x)) [];;*)
let set_extension f = it_map union f [];;

let it_pair_list f init pair_list = it_list f init (combine pair_list)
;;

(*\
\par\noindent
Example:
\begin{caml_example}
set_extension (make_set o explode) ["language";"machine"];;
\end{caml_example}

\begin{caml_primitive}
num_map
\end{caml_primitive}
\verb"num_map f l" maps \verb"f" on \verb"l" providing to each call the
position in the list of the argument of the call:
\par\noindent
\verb"num_map f [e1; e2; ... ; ei; ... ; en] ="\\
\verb"          [f 1 e1; f 2 e2; ... ; f i ei; ... ; f n en]"
\par\noindent
Example:
\begin{caml_example}
num_map pair ["a";"b";"c"];;
num_map
 (fun i e ->
   print_string"The ";print_num i;print_string"th element is: ";
   message e)
 ["a";"b";"c";"d"];;
\end{caml_example}

\verb"num_map" may be defined with
\begin{caml}
let num_map f = snd o fold consf 1
    where consf i x = (i+1,f i x);;
\end{caml}

But in fact \verb"num_map" is just a closure of \verb"map_i", since we have:
\begin{caml_example}
let num_map = (C map_i) 1;;
\end{caml_example}
\*)

(*|
Value num_map : ((num -> 'a -> 'b) -> 'a list -> 'b list)
{fold,o}
|*)
let num_map f = map_i f 1;;

(*\
\section{Merging and sorting lists}
\index{Merging and sorting lists}
\begin{caml_primitive}
merge
merge_num
sort_num
\end{caml_primitive}

\begin{itemize}
\item \verb"merge" is used to get the union of two sets represented as
 sorted lists.
\item \verb"merge_num" is specially devoted to lists of numbers.
\item \verb"sort_num" sorts lists of numbers in increasing order.
\end{itemize}
\*)
(*|
Value merge : (('a & 'a -> bool) -> 'a list -> 'a list -> 'a list)
|*)
let merge ord l1 l2 = (merge_ord (l1,l2) ? failwith "merge")
  where rec merge_ord = function
	(h1::t1),(h2::t2) -> if h1 = h2 then h1::merge_ord (t1,t2)
		             if ord(h1,h2) then h1::merge_ord(t1,(h2::t2))
                             else h2::merge_ord((h1::t1),t2)
|	[],l -> l
|	l,[] -> l;;

(*|
Value merge_num : (num list -> num list -> num list)
{merge}
|*)
let merge_num = merge (prefix <);;

let sort_num = sort (prefix <);;

(*\
\section{Association lists}
\index{Association lists}
\begin{caml_primitive}
inverse_assoc
\end{caml_primitive}

\begin{itemize}
\item \verb"inverse_assoc" built the inverse a table of association.
\end{itemize}
\*)

let inverse_assoc = map (function (x,y) -> (y,x));;

(*\begin{caml_ignore}*)
(*\
\section{Removing the last elements of a list}
\begin{caml_primitive}
except_last_n
\end{caml_primitive}

\begin{itemize}
\item \verb"except_last_n n l" returns the elements of the list \verb"l" the
\verb"n" last being excepted.
\end{itemize}

\*)
(*
let except_last_n n l =

 type 'a num_or_list = Int of int | List of 'a list in

  let rec except_aux n = function
    [] -> Int #0
  | (x::l) -> match except_aux n l with
                 Int p -> if p == n then List [x]
                          else Int (succ_int p)
               | List l -> List (x::l) in
 (match
   except_aux (int_of_num n) l
  with Int _ -> failwith "except_last_n"
     | List l -> l)
;;
*)
(* latex_caml_file has to ignore this definition since end_it_list is
   documented in the prelude *)
(*|
Value end_it_list : (('a -> 'a -> 'a) -> 'a -> 'a list -> 'a)
{it_list}
|*)
let end_it_list f default = fun [] -> default | (b::l) -> it_list f b l;;
(*\end{caml_ignore}*)
