/*************************************************************************/
/*                                                                       */
/*                     Projet      Formel                                */
/*                                                                       */
/*                            CAML                                       */
/*                                                                       */
/*************************************************************************/
/*                                                                       */
/*                            Inria                                      */
/*                      Domaine de Voluceau                              */
/*                      78150  Rocquencourt                              */
/*                            France                                     */
/*                                                                       */
/*************************************************************************/

/* xdr_get.ml    Define in C the function get                            */
/*		 Gilles Dowek						 */

#include <rpc/rpc.h>

typedef struct bitstring { int size; char *ptr; } bitstring;

bool_t xdr_fake(xdrs, objp)
XDR *xdrs;
char **objp;
{
    if (xdrs->x_op == XDR_ENCODE)
	return (XDR_PUTBYTES(xdrs,
			     ((bitstring *)objp)->ptr,
			     ((bitstring *)objp)->size));
    if (xdrs->x_op == XDR_DECODE) {
	*objp = (char *)xdrs;
	return TRUE;
    }
    if (xdrs->x_op == XDR_FREE)
	return TRUE;
    return FALSE;
}

int caml_xdr_putbytes(xdrs, bs)
XDR *xdrs;
bitstring *bs;
{
    return (XDR_PUTBYTES(xdrs, bs->ptr, bs->size));
}

int caml_xdr_getbytes(xdrs, bs)
XDR *xdrs;
bitstring *bs;
{
    return (XDR_GETBYTES(xdrs, bs->ptr, bs->size));
}
