#include <stdio.h>
#include <rpc/rpc.h>
#include <sys/time.h>
#include "dir.h"

extern int errno;
extern int caml_raise();
extern bool_t xdr_fake();

typedef struct bitstring { int size; char *ptr; } bitstring;

static struct timeval TIMEOUT = { 25, 0 };

XDR *caml_dir (server, argp)
char *server;
bitstring *argp;
{
    CLIENT *cl;
    XDR *result;
    enum clnt_stat res;

    cl = clnt_create(server, DIRPROG, DIRVERS, "tcp");
    if (cl == NULL) {
	clnt_pcreateerror(server);
	caml_raise(1);
    }
    res = clnt_call(cl, READDIR, xdr_fake, argp, xdr_fake, &result, TIMEOUT);
    if (res != RPC_SUCCESS) {
	clnt_perror(cl, server);
	caml_raise(2);
    }
    return result;
}
