/* ************************************************************************* */
/*                             FICHIER x11.c                                 */
/* ************************************************************************* */
/* Ce fichier contient la partie C de l'implemenation du Bitmap Virtuel      */
/* pour les stations de travail sous X-Windows version 11.                   */
/* il va de pair avec les fichiers x11.h et x11.ll                           */
/*                                                                           */
/* Auteur: Pierre DUQUESNOY (ILOG)                  Date:  25 Novembre 1988  */
/* ************************************************************************* */

#include "x11.h"

extern char *malloc (); 
extern char *realloc ();

int *lispxioerrorsymbol;
int *lispxerrorsymbol;
int *lisperrorsymbol;
int *lispnil;

int LLXError (dpy, event)
Display *dpy;
XErrorEvent *event;{

	char buffer1 [BUFSIZ];
	char buffer2 [BUFSIZ];
	char message1 [3*BUFSIZ];
	char message2 [BUFSIZ];
	char num [10];
        static  int count = 0; 
	
	XGetErrorText (dpy, event->error_code, buffer1, BUFSIZ);
	sprintf (num, "%d", event->request_code);
	XGetErrorDatabaseText (dpy, "XRequest", num, num, buffer2, BUFSIZ);
	sprintf (message1,
		 "[%d] %s (%d) %s",
		 ++count, buffer2, event->minor_code, buffer1);
	sprintf (message2,
		 "(%d . %d)",
		 (event->resourceid) >> 16, (event->resourceid) & 0xffff);
	pusharg (LLT_T, lispxerrorsymbol);
	pusharg (LLT_STRING, message1); 
	pusharg (LLT_STRING, message2); 
	lispcall (LLT_T, 3, lisperrorsymbol);
	return (0);
}

int LLXIOError (dpy)
Display *dpy;
{
	lispcall (LLT_T, 0, lispxioerrorsymbol);
}
	

initialise (llnil, llxerror, llerror, llxioerror)
int *llnil, *llxerror, *llerror, *llxioerror;{
	int LLXError ();
	
	lispnil = llnil;
	lispxioerrorsymbol = llxioerror;
	lispxerrorsymbol = llxerror;
	lisperrorsymbol = llerror; 
	XSetIOErrorHandler (LLXIOError);
	XSetErrorHandler (LLXError);
}

struct LLDisplay *bitprologue (name, mask, override, xmax, ymax, fd)
char *name;
unsigned long mask;
int override;
int *xmax, *ymax;
int *fd;{
	unsigned long whitepixel, blackpixel;
	int screen;
	char *def;
	XGCValues values;
	struct LLDisplay *dpy;
	
       	dpy = (struct LLDisplay *) malloc (sizeof (struct LLDisplay));
	dpy->display = XOpenDisplay (name);
	if ((dpy->display) == NULL) {
		perror (MESSAGE1);
		return ((struct LLDisplay *) NULL);
	}
	screen = XDefaultScreen (dpy->display); 
	*xmax = XDisplayWidth (dpy->display, screen) - 1 ; 
	*ymax = XDisplayHeight (dpy->display, screen) - 1 ; 
	*fd = ConnectionNumber (dpy->display) ;
	dpy->subeventmask = mask ;
	dpy->eventmask = mask|EVENTMASK ;
	dpy->override = override;
	dpy->root = XRootWindow (dpy->display, screen); 
	dpy->colormap = DefaultColormap(dpy->display, screen);
	dpy->depth = XDefaultDepth (dpy->display, screen);
	whitepixel = XWhitePixel (dpy->display, screen);
	blackpixel = XBlackPixel (dpy->display, screen);
	dpy->lispcontext = XUniqueContext ();
	dpy->nbpoints = NBPOINTS;
	dpy->points = (XPoint *) malloc (dpy->nbpoints * sizeof (XPoint)); 
 	if (dpy->points == 0) {
		perror(MESSAGE2);
		return ((struct LLDisplay *) NULL);
	}
	dpy->setimage = XCreateImage (dpy->display,
				      XDefaultVisual (dpy->display, screen),
				      1, XYBitmap, 0, NULL, xmax, 1, 16, 0); 
	dpy->setcolorimage = XCreateImage (dpy->display,
					   XDefaultVisual (dpy->display,
							   screen),
					   dpy->depth, ZPixmap, 0, NULL,
					   xmax, 1, 16, 0); 
	values.graphics_exposures = False; 
	dpy->fullgc  = XCreateGC (dpy->display, dpy->root, 
				  FULLGCMASK, &values);
        dpy->currentwindow = dpy->root;
        dpy->currentgc = XDefaultGC (dpy->display, screen); 
        dpy->offset_x = 0;
        dpy->offset_y = 0;
	dpy->hostname = malloc(HOSTSIZE);
	gethostname(dpy->hostname, HOSTSIZE);
	return (dpy); 
}

int x_release (dpy)
struct LLDisplay *dpy; {
	return (XVendorRelease (dpy->display));
}
	
int x_version (dpy)
struct LLDisplay *dpy; {
	return (XProtocolVersion (dpy->display));
}
	
int x_revision (dpy)
struct LLDisplay *dpy; {
	return (XProtocolRevision (dpy->display));
}
	
/* ***************************** Pas teste' a` ILOG ***************************
#ifdef S5
gethostname(name, namelen)
char *name;
int namelen; {
    struct utsname uts;
   
    uname(&uts);
    return(strcpy(name, uts.nodename));
}
#endif
**************************************************************************** */

init_pixels (dpy, fore, back, planemask)
struct LLDisplay *dpy;
int fore, back, planemask; {
	dpy->ForePixel = fore;
	dpy->BackPixel = back;
	XSetForeground(dpy->display, dpy->fullgc, fore);
	XSetBackground(dpy->display, dpy->fullgc, back);
	dpy->monoplane = planemask;
}

bitepilogue (dpy)
struct LLDisplay *dpy; {
	XDestroyImage (dpy->setimage);
	XSetCloseDownMode (dpy->display, DestroyAll);
	XCloseDisplay (dpy->display);
        free ((char *)dpy->points); 
        free ((char *)dpy->hostname); 
	free ((char *)dpy);
}

bitmap_flush (dpy) 
struct LLDisplay *dpy; {
	XFlush (dpy->display) ;
}

bitmap_sync (dpy) 
struct LLDisplay *dpy; {
	XSync (dpy->display, FLUSH);
}

bitmap_refresh (dpy, cursor)
struct LLDisplay *dpy;
Cursor cursor; {
	Window win;
	XSetWindowAttributes xswa;
	
	xswa.override_redirect = True;
	xswa.cursor = cursor; 
	win = XCreateWindow (dpy->display, dpy->root, 0, 0, 9999, 9999, 0,
			     dpy->depth, InputOutput, CopyFromParent,
			     CWOverrideRedirect|CWCursor, &xswa); 
	XMapWindow(dpy->display, win);
	XFlush(dpy->display);
	XDestroyWindow (dpy->display, win);	
	XFlush(dpy->display);
}

GC create_graph_env (dpy, window, font, width, style, pattern, mode)
struct LLDisplay *dpy; 
Window window;
XFontStruct *font;
int width, style, mode;
Pixmap pattern;{
 	GC gc;
	XGCValues values;
	
	values.foreground = dpy->ForePixel ;
	values.background = dpy->BackPixel ;
	values.line_width = width ;
	values.line_style = style ;
	values.tile = pattern ;
	values.font = font->fid;
	values.function = mode;
	values.plane_mask = AllPlanes;
	values.fill_style = FillSolid;
	values.graphics_exposures = True; 
	values.subwindow_mode = IncludeInferiors;
	gc = XCreateGC (dpy->display, window, GCMASK, &values);
	return (gc);
}

current_clip (dpy, gc, x, y, w, h)
struct LLDisplay *dpy; 
GC gc;
int x, y, w, h; {
	XRectangle clip;
	
	clip.x = x ;
	clip.y = y ;
	clip.width =  w <= 0 ? 1 : w ;
	clip.height = h <= 0 ? 1 : h ;
	XSetClipRectangles (dpy->display, gc, 0, 0, &clip, 1, Unsorted); 
}

Window root_window (dpy)
struct LLDisplay *dpy; {
	return (dpy->root);
}

Window create_window (dpy, win, x, y, w, h, title, hilited, visible, cursor)
struct LLDisplay *dpy; 
int win;
int x, y, w, h;
char *title;
int hilited, visible; 
Cursor cursor;{
	Window window;
	XSetWindowAttributes attributes;
        XSizeHints hints;
        XClassHint classhint;
        XWMHints wmhints;
	Atom delete_save[2];
	Atom protocol;

	if (hilited) {
		x -= 1;
		y -= 1;
	} 
	if (w <= 0) w = 1;
	if (h <= 0) h = 1;
	attributes.background_pixel = dpy->BackPixel;                    
	attributes.border_pixel = dpy->ForePixel;
	attributes.override_redirect = dpy->override; 
	attributes.cursor = cursor;  
	attributes.event_mask = NULL;
	window = XCreateWindow (dpy->display, dpy->root, x, y, w, h,
				BORDERWIDTH, dpy->depth, InputOutput,
				CopyFromParent, WINDOWMASK, &attributes);

        hints.x = x;
        hints.y = y;
        hints.width = w; 
        hints.height = h;
        hints.flags = USPosition|USSize;
        XSetNormalHints(dpy->display, window, &hints);

        classhint.res_name = LELISP;
        classhint.res_class = LELISP;
        XSetClassHint(dpy->display, window, &classhint);

	wmhints.flags = InputHint;
	wmhints.input = True;
	XSetWMHints(dpy->display, window, &wmhints);

	XStoreName (dpy->display, window, title); 
        XSetIconName(dpy->display, window, title);
	SetHostName(dpy->display, window, dpy->hostname);

	XSetWindowBorderWidth (dpy->display, window,
			       hilited? BIGBORDERWIDTH : BORDERWIDTH);

	XSelectInput (dpy->display, window, dpy->eventmask);
	delete_save[0] = XInternAtom(dpy->display,"WM_DELETE_WINDOW",0);
	delete_save[1] = XInternAtom(dpy->display,"WM_SAVE_YOURSELF",0);
	protocol = XInternAtom(dpy->display,"WM_PROTOCOLS",0);
	XChangeProperty(dpy->display, window, protocol, protocol, 32,
			PropModeReplace,delete_save, 1);	
	return ((set_userdata (dpy, window, win)) ? window : (Window) NULL);
}

/* Why isn't this in the library? My dear! */

static SetHostName(dpy, w, name)
	register Display *dpy;
	Window w;
	char *name;
{
	XChangeProperty(dpy, w, XA_WM_CLIENT_MACHINE, XA_STRING, 
		8, PropModeReplace, (unsigned char *)name, strlen(name));
}

activate_window (dpy, window)
struct LLDisplay *dpy; 
Window window; {
 	XMapWindow (dpy->display, window);
}

Window create_subwindow (dpy, win, x, y, w, h, visible, father)
struct LLDisplay *dpy; 
int win;
int x, y, w, h, visible;
Window father; {
	Window window;
	XSetWindowAttributes attributes;
	
	if (w <= 0) w = 1;
	if (h <= 0) h = 1;
	attributes.event_mask = NULL ;
	window = XCreateWindow (dpy->display, father, x, y, w, h, 0, 0,
				InputOnly, CopyFromParent, 
				SUBWINDOWMASK, &attributes);
	if (visible) XMapWindow (dpy->display, window);
	XSelectInput (dpy->display, window, dpy->subeventmask);
	return ((set_userdata (dpy, window, win)) ? window : (Window) NULL);
}

modify_window (dpy, window, xyp, x, y, whp, w, h, topp, titlep, title, hilitedp, hilited, visiblep, visible)
struct LLDisplay *dpy; 
Window window;
int xyp, whp, topp, titlep, hilitedp, visiblep, x, y, w, h, hilited, visible;
char *title;{
        XSizeHints hints;
	
	XSelectInput (dpy->display, window, (unsigned long)NULL);
	if (whp){
		if (w <= 0) w = 1;
		if (h <= 0) h = 1;
	}
	if (xyp && whp)  
		XMoveResizeWindow (dpy->display, window, x, y, w, h);
	else if (xyp) 
		XMoveWindow (dpy->display, window, x, y);
	else if (whp) 
		XResizeWindow (dpy->display, window, w, h);
	if (topp) {
	        if (xyp) {
			hints.x = x;
			hints.y = y;
			hints.flags = USPosition;
		} if (whp) {
			hints.width = w; 
			hints.height = h;
			hints.flags = USSize;
		} if (xyp && whp) {
			hints.flags = USPosition|USSize;
		} if (xyp || whp) {
			XSetNormalHints(dpy->display, window, &hints);
		} if (titlep) {
			XStoreName (dpy->display, window, title);
			XSetIconName (dpy->display, window, title);
		} if (hilitedp) {
			XSetWindowBorderWidth (dpy->display, window, 
					       hilited ? 
					       BIGBORDERWIDTH : 
					       BORDERWIDTH);
			if (hilited) {			
				hints.x = x-1;
				hints.y = y-1;
				hints.flags = USPosition;
				XSetNormalHints(dpy->display, window, &hints);
				XMoveWindow (dpy->display, window, x-1, y-1);
			} else {
				hints.y = y;
				hints.x = x;
				hints.flags = USPosition;
				XSetNormalHints(dpy->display, window, &hints);
				XMoveWindow (dpy->display, window, x, y);
			}
		}
	}
	XSelectInput (dpy->display, window,
		      topp ? dpy->eventmask : dpy->subeventmask);
	if (visiblep) {
		if (visible) XMapWindow (dpy->display, window);
		else XUnmapWindow (dpy->display, window);
	}
}

pop_window (dpy, window) 
struct LLDisplay *dpy; 
Window window;{
	XRaiseWindow (dpy->display, window);
}

move_behind_window (dpy, window1) 
struct LLDisplay *dpy; 
Window window1;{
	XLowerWindow (dpy->display, window1);
}

kill_window (dpy, window, gc)
struct LLDisplay *dpy; 
Window window;
GC gc;{
        kill_userdata (dpy, window);
	XDestroyWindow (dpy->display, window);	
	XFreeGC (dpy->display, gc);
}

/* correction du bug du kill-window su rtx11 */

kill_ll_window (dpy, window, gc)
struct LLDisplay *dpy; 
Window window;
GC gc;{
        kill_userdata (dpy, window);
	XFreeGC (dpy->display, gc);
}

current_window (dpy, window, gc, dx, dy)
struct LLDisplay *dpy; 
Window window;
GC gc;
int dx, dy; {
	dpy->offset_x = dx ;
        dpy->offset_y = dy ;
	dpy->currentwindow = window;
	dpy->currentgc = gc;
}

int find_window (dpy, x, y)
struct LLDisplay *dpy; 
int x, y;{
	Window w, w1; 
	int x1, y1;
	
	x1= x ;
	y1= y ;
	w = dpy->root ;
	do {
		w1= w ;
		XTranslateCoordinates (dpy->display, dpy->root, w1,
				       x1, y1, &x, &y, &w);
	} while (w != NULL);
	return (get_userdata (dpy, w1));
}

map_window (dpy, window, x, y, lx, ly)
struct LLDisplay *dpy; 
Window window;
int x, y ;
int *lx, *ly;{
	Window w;
	
	XTranslateCoordinates (dpy->display, dpy->root, window,
			       x, y, lx, ly, &w);
	*lx = (*lx + 1) & 0xffff;
	*ly = (*ly + 1) & 0xffff;
}

flush_event (dpy)
struct LLDisplay *dpy; {
	XSync (dpy->display, DISCARD) ;
}

grab_event (dpy, window)
struct LLDisplay *dpy; 
Window window;{
	return (XGrabPointer (dpy->display, window, False,ButtonPressMask | ButtonReleaseMask | ButtonMotionMask | EnterWindowMask | LeaveWindowMask | PointerMotionMask ,GrabModeAsync, GrabModeAsync, None, None, CurrentTime)); 
}

ungrab_event (dpy)
struct LLDisplay *dpy; {
	XUngrabPointer (dpy->display, CurrentTime);
}

int *eventp (dpy)
struct LLDisplay *dpy; {
	return XPending (dpy->display) ? (int *) 1 : lispnil ;
}

int wait_in_socket (read_fds)
int read_fds;{
	int nb_fds ;
	
        nb_fds = select (32, &read_fds, 0, 0, 0);
	return (nb_fds > 0 ? read_fds : nb_fds);
}

int *read_event (dpy, event)
struct LLDisplay *dpy; 
struct LLEvent *event;{
	XEvent evt;
        int *was_in_socket;
	
	was_in_socket = XPending (dpy->display) ? lispnil : (int *) 1 ;
	if ((was_in_socket == lispnil) ||
	    (wait_in_socket (1 << ConnectionNumber (dpy->display)) > 0)) {
		XNextEvent (dpy->display, &evt);
		parse_event (dpy, event, &evt);
		return (was_in_socket);
	} else
		return((int *) 0);
}

int *peek_event (dpy, event)
struct LLDisplay *dpy; 
struct LLEvent *event;{
	XEvent evt;
        int *was_in_socket;
	
	was_in_socket = XPending (dpy->display) ? lispnil : (int *) 1 ;	
	if ((was_in_socket == lispnil) ||
	    (wait_in_socket (1 << ConnectionNumber (dpy->display)) > 0)) {
		XPeekEvent (dpy->display, &evt);
		parse_event (dpy, event, &evt);
		return (was_in_socket);
	} else
		return((int *) 0);
}

read_mouse (dpy, event)
struct LLDisplay *dpy; 
struct LLEvent *event;{
	Window w, w1, w2;
	int x, y, gx, gy;
	unsigned int state;
	char c;
	
	w2 = dpy->root;
	do {
		w = w2;
		XQueryPointer (dpy->display, w, &w1, &w2,
			       &gx, &gy, &x, &y, &state);
	} while (w2 != NULL);
	event->window = (int *) get_userdata (dpy, w) ;
	event->gx = gx & 0xffff;
	event->gy = gy & 0xffff;
	event->x = x & 0xffff;
	event->y = y & 0xffff;	
	c = BUTTON (BIT (state, Button1Mask), 
		    BIT (state, Button2Mask),  
		    BIT (state, Button3Mask));
	event->detail = c == 0 ? 0 : (1 + DETAIL (c, state)) & 0xffff; 
}

parse_event (dpy, llevent, xevent)
struct LLDisplay *dpy; 
struct LLEvent *llevent;
XEvent *xevent;{
	int state = NULL;
	char buffer[BUFFERSIZE];
	KeySym funkey;
	char c;
	char *lookup ;
	int nbytes;

	llevent->code = xevent->type & 0xffff;
	switch (xevent->type){
	case KeyPress:
	case KeyRelease:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xkey.window) ;
		llevent->gx = xevent->xkey.x_root & 0xffff;
		llevent->gy = xevent->xkey.y_root & 0xffff;
		llevent->x = xevent->xkey.x & 0xffff;
		llevent->y = xevent->xkey.y & 0xffff;
#ifdef IBMRT
                lookup = (char *) XLookupMapping ( &(xevent->xkey), &nbytes);
                if (nbytes == 1) 
                        llevent->detail = lookup[0];
                else{
#endif IBMRT
                        if (NULL != XLookupString (&(xevent->xkey), buffer, BUFFERSIZE,
                                                   &funkey, NULL))
                                llevent->detail = buffer[0] & 0xffff;
                        else{  
                                llevent->code = FUNKEYCODE ;
                                llevent->detail = funkey & 0xffff;
                        }
#ifdef IBMRT
                }
#endif IBMRT
		break;
	case ButtonPress:
	case ButtonRelease:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xbutton.window) ;
		llevent->gx = xevent->xbutton.x_root & 0xffff;
		llevent->gy = xevent->xbutton.y_root & 0xffff;
		llevent->x = xevent->xbutton.x & 0xffff;
		llevent->y = xevent->xbutton.y & 0xffff;
		state = xevent->xbutton.state;
		llevent->detail = DETAIL (xevent->xbutton.button, state)
			& 0xffff ;
		break;
	case MotionNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xmotion.window);
		llevent->gx = xevent->xmotion.x_root & 0xffff;
		llevent->gy = xevent->xmotion.y_root & 0xffff;
		llevent->x = xevent->xmotion.x & 0xffff;
		llevent->y = xevent->xmotion.y & 0xffff;
		state = xevent->xmotion.state;
		if (NULL != (c = BUTTON (BIT (state, Button1Mask), 
					 BIT (state, Button2Mask),  
					 BIT (state, Button3Mask))))
			llevent->detail = DETAIL (c, state) & 0xffff; 
		break;
	case EnterNotify:
	case LeaveNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xcrossing.window);
		llevent->gx = xevent->xcrossing.x_root & 0xffff;
		llevent->gy = xevent->xcrossing.y_root & 0xffff;
		llevent->x = xevent->xcrossing.x & 0xffff;
		llevent->y = xevent->xcrossing.y & 0xffff;
		state = xevent->xcrossing.state;
		if (NULL != (c = BUTTON (BIT (state, Button1Mask), 
					 BIT (state, Button2Mask),  
					 BIT (state, Button3Mask))))
			llevent->detail = DETAIL (c, state) & 0xffff; 
		break;
	case Expose:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xexpose.window);
		llevent->x = xevent->xexpose.x & 0xffff;
		llevent->y = xevent->xexpose.y & 0xffff;
		llevent->w = xevent->xexpose.width & 0xffff;
		llevent->h = xevent->xexpose.height & 0xffff;
		break;
	case GraphicsExpose:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xgraphicsexpose.drawable);
		llevent->x = xevent->xgraphicsexpose.x & 0xffff;
		llevent->y = xevent->xgraphicsexpose.y & 0xffff;
		llevent->w = xevent->xgraphicsexpose.width & 0xffff;
		llevent->h = xevent->xgraphicsexpose.height & 0xffff;
		break;
	case CreateNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xcreatewindow.window);
		llevent->x = xevent->xcreatewindow.x & 0xffff;
		llevent->y = xevent->xcreatewindow.y & 0xffff;
		llevent->w = xevent->xcreatewindow.width & 0xffff;
		llevent->h = xevent->xcreatewindow.height & 0xffff;
		break;
	case ConfigureNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xconfigure.window);
		llevent->x = xevent->xconfigure.x & 0xffff;
		llevent->y = xevent->xconfigure.y & 0xffff;
		llevent->w = xevent->xconfigure.width & 0xffff;
		llevent->h = xevent->xconfigure.height & 0xffff;
		break;
	case ConfigureRequest:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xconfigurerequest.window);
		llevent->x = xevent->xconfigurerequest.x & 0xffff;
		llevent->y = xevent->xconfigurerequest.y & 0xffff;
		llevent->w = xevent->xconfigurerequest.width & 0xffff;
		llevent->h = xevent->xconfigurerequest.height & 0xffff;
		break;
	case ResizeRequest:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xresizerequest.window);
		llevent->w = xevent->xresizerequest.width & 0xffff;
		llevent->h = xevent->xresizerequest.height & 0xffff;
		break;
	case ReparentNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xreparent.window);
		llevent->x = xevent->xreparent.x & 0xffff;
		llevent->y = xevent->xreparent.y & 0xffff;
		break;
	case GravityNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xgravity.window);
		llevent->x = xevent->xgravity.x & 0xffff;
		llevent->y = xevent->xgravity.y & 0xffff;
		break;
	case DestroyNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xdestroywindow.window);
		break;
	case UnmapNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xunmap.window);
		break;
	case MapNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xmap.window);
		break;
	case FocusIn:
	case FocusOut:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xfocus.window);
		llevent->detail = xevent->xfocus.mode & 0xffff;
		break;
	case NoExpose:
		llevent->window = lispnil;
		break;
	case VisibilityNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xvisibility.window);
		break;
	case KeymapNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xkeymap.window);
		break;
	case CirculateNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xcirculate.window);
		break;
	case PropertyNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xproperty.window);
		break;
	case SelectionNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xcirculaterequest.window);
		break;
	case ColormapNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xcolormap.window);
		break;
	case MappingNotify:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xmapping.window);
		break;
	case ClientMessage:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xclient.window);
		break;
	case SelectionClear:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xselectionclear.window);
		break;
	case MapRequest:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xmaprequest.window);
		break;
	case CirculateRequest:
		llevent->window = (int *) get_userdata
			(dpy, xevent->xcirculaterequest.window);
		break;
	case SelectionRequest:
		break;
	case LASTEvent:
		break;
	}
}

clear_graph_env (dpy, x, y, w, h)
struct LLDisplay *dpy; 
int x, y, w, h;{
	x += dpy->offset_x;
	y += dpy->offset_y;
	if ((w > 0) && (h > 0))
		XClearArea (dpy->display, dpy->currentwindow, 
                            x, y, w, h, False);
}

XFontStruct *load_font (dpy, font)
struct LLDisplay *dpy; 
char *font;{
	return XLoadQueryFont (dpy->display, font);
}

current_font (dpy, font)
struct LLDisplay *dpy; 
XFontStruct *font;{
	XSetFont (dpy->display, dpy->currentgc, font->fid);
}

int font_ascent (font)
XFontStruct *font;{
	return (font->ascent);
}

int font_height (font)
XFontStruct *font; {
	return (font->ascent + font->descent);
}

draw_cn (dpy, x, y, cn, mode)
struct LLDisplay *dpy; 
int x, y;
int mode;
char cn;{
	char string[2];

	x += dpy->offset_x;
	y += dpy->offset_y;
	string [0] = cn;
	if (mode == 3)
		XDrawImageString (dpy->display, dpy->currentwindow, 
				  dpy->currentgc, x, y, string, 1);
	else
		XDrawString (dpy->display, dpy->currentwindow, dpy->currentgc, 
		             x, y, string, 1);
}

draw_string (dpy, x, y, string, start, length, mode)
struct LLDisplay *dpy; 
int x, y, start, length;
int mode;
char *string;{
	x += dpy->offset_x;
	y += dpy->offset_y;
	string += start;
	if (mode == 3)
		XDrawImageString (dpy->display, dpy->currentwindow, 
				  dpy->currentgc, x, y, string, length);
	else
		XDrawString (dpy->display, dpy->currentwindow, dpy->currentgc,
			     x, y, string, length);
}

int width_string (font, string, start, length)
XFontStruct *font;
int start, length;
char *string;{
	string += start;
	return XTextWidth (font, string, length);
}

int height_string (font, string, start, length)
XFontStruct *font;
int start, length;
char *string;{
	XCharStruct overall;
	int direction, ascent, descent;

	string += start;
	XTextExtents (font, string, length,
		      &direction, &ascent, &descent, &overall);	
	return (overall.ascent + overall.descent);
}

int x_base_string (font, string, start, length)
XFontStruct *font;
int start, length;
char *string;{
	XCharStruct overall;
	int direction, ascent, descent;
	
	string += start;
	XTextExtents (font, string, length,
		      &direction, &ascent, &descent, &overall);	
	return overall.lbearing;
}

int y_base_string (font, string, start, length)
XFontStruct *font;
int start, length;
char *string;{
	XCharStruct overall;
	int direction, ascent, descent;
	
	string += start;
	XTextExtents (font, string, length,
		      &direction, &ascent, &descent, &overall);	
	return overall.ascent;
}

current_mode (dpy, mode)
struct LLDisplay *dpy; 
int mode;{
	if (mode == 3)
		XSetPlaneMask (dpy->display, dpy->currentgc, AllPlanes);
	else
		XSetPlaneMask (dpy->display, dpy->currentgc, dpy->monoplane);
	XSetFunction (dpy->display, dpy->currentgc, mode);
}

current_line_style (dpy, width, style)
struct LLDisplay *dpy; 
unsigned width; 
int style;{
	
	XSetLineAttributes (dpy->display, dpy->currentgc, width, style,
			    CapButt, JoinMiter);
}

current_pattern (dpy, pattern)
struct LLDisplay *dpy; 
Pixmap pattern;{
	XSetTile (dpy->display, dpy->currentgc, pattern); 
}

draw_point (dpy, x, y)
struct LLDisplay *dpy; 
int x, y;{
	x += dpy->offset_x;
	y += dpy->offset_y;
	XDrawPoint (dpy->display, dpy->currentwindow, dpy->currentgc, x, y);
}

draw_polymarker (dpy, n, vx, vy)
struct LLDisplay *dpy; 
int n;
int vx[], vy[];{

	if (store_points (dpy, n, vx, vy))		
		XDrawPoints (dpy->display, dpy->currentwindow, dpy->currentgc,
			     dpy->points, n, CoordModeOrigin);
}

draw_line (dpy, x1, y1, x2, y2)
struct LLDisplay *dpy; 
int x1, y1, x2, y2;{
	x1 += dpy->offset_x;
	y1 += dpy->offset_y;
	x2 += dpy->offset_x;
	y2 += dpy->offset_y;
	XDrawLine (dpy->display, dpy->currentwindow, dpy->currentgc,
		   x1, y1, x2, y2);
}

draw_rectangle (dpy, x, y, w, h)
struct LLDisplay *dpy; 
int x, y, w, h;{
	x += dpy->offset_x;
	y += dpy->offset_y;
	if ((w > 0) && (h > 0))
		XDrawRectangle (dpy->display, dpy->currentwindow,
				dpy->currentgc, x, y, w, h);
}

draw_ellipse (dpy, x, y, rx, ry)
struct LLDisplay *dpy; 
int x, y, rx, ry;{
	x += dpy->offset_x - rx;
	y += dpy->offset_y - ry;
	if ((rx > 0) && (ry > 0))
	        XDrawArc (dpy->display, dpy->currentwindow, dpy->currentgc,
	  	          x, y, rx+rx, ry+ry, NULL, TWOPI);
}	
	
draw_polyline (dpy, n, vx, vy)
struct LLDisplay *dpy; 
int n;
int vx[], vy[];{

	if (store_points (dpy, n, vx, vy))
		XDrawLines (dpy->display, dpy->currentwindow, dpy->currentgc,
			    dpy->points, n, CoordModeOrigin);
}

fill_rectangle (dpy, x, y, w, h, pattern)
struct LLDisplay *dpy; 
int x, y, w, h;
int pattern;{
	x += dpy->offset_x;
	y += dpy->offset_y;
	if ((w > 0) && (h > 0)){
		if (pattern > 1) 
			XSetFillStyle (dpy->display, dpy->currentgc,
				       FillTiled);
		XFillRectangle (dpy->display, dpy->currentwindow,
				dpy->currentgc, x, y, w, h);
		if (pattern > 1) 
			XSetFillStyle (dpy->display, dpy->currentgc,
				       FillSolid);
	}
}

fill_ellipse (dpy, x, y, rx, ry, pattern)
struct LLDisplay *dpy; 
int x, y, rx, ry;
int pattern;{

	x += dpy->offset_x - rx;
	y += dpy->offset_y - ry;
	if ((rx > 0) && (ry > 0)){
		if (pattern > 1) 
			XSetFillStyle (dpy->display, dpy->currentgc,
				       FillTiled);
        	XFillArc (dpy->display, dpy->currentwindow, dpy->currentgc,
		          x, y, rx+rx, ry+ry, NULL, TWOPI);
		if (pattern > 1) 
			XSetFillStyle (dpy->display, dpy->currentgc,
				       FillSolid);
	}
}

fill_area (dpy, n, vx, vy, pattern)
struct LLDisplay *dpy; 
int n;
int vx[], vy[];
int pattern;{

	if (store_points (dpy, n, vx, vy)){
		if (pattern > 1) 
			XSetFillStyle (dpy->display, dpy->currentgc,
				       FillTiled);
		XFillPolygon (dpy->display, dpy->currentwindow, dpy->currentgc,
			      dpy->points, n, Complex, CoordModeOrigin);
		if (pattern > 1) 
			XSetFillStyle (dpy->display, dpy->currentgc,
				       FillSolid);
	}
}

/* ************************************************************************* */

int store_points (dpy, n, vx, vy)
struct LLDisplay *dpy; 
int n;
int vx[], vy[];{
	int i;

	while (n > dpy->nbpoints){
		dpy->nbpoints = 2 * dpy->nbpoints ;
		dpy->points = (XPoint *) realloc ((char *)dpy->points,
					     dpy->nbpoints * sizeof (XPoint));
		if (dpy->points == 0) {
			perror(MESSAGE3);
			return (0);
		}
	}
	for (i = 0; i < n; i++){
		dpy->points[i].x = *vx++ + dpy->offset_x ;
		dpy->points[i].y = *vy++ + dpy->offset_y ;
	}
	return (1);
}

int set_userdata (dpy, win, lisp)
struct LLDisplay *dpy; 
Window win;
int lisp; {
	if (XSaveContext (dpy->display, win, dpy->lispcontext, lisp) != NULL) {
		perror(MESSAGE4);
		return (0);
	}
	return (1);
}

int get_userdata (dpy, win)
struct LLDisplay *dpy; 
Window win; {
        int lisp;
	if (XFindContext (dpy->display, win, dpy->lispcontext, &lisp)
	    != NULL)
		lisp = (int) lispnil;
	return (lisp);
}

kill_userdata (dpy, win)
struct LLDisplay *dpy; 
Window win;{
	
	XDeleteContext (dpy->display, win, dpy->lispcontext);
}

/* ************************************************************************* */

GC default_gc (dpy)
struct LLDisplay *dpy; {
	return dpy->fullgc;
}

Pixmap create_bitmap (dpy, w, h)
struct LLDisplay *dpy; 
unsigned int w, h ;{
	Pixmap pixmap; 
	
	if (w <= 0) w = 1;
	if (h <= 0) h = 1;
	pixmap = XCreatePixmap (dpy->display, dpy->root, w, h, dpy->depth);
	return (pixmap); 
}

kill_bitmap (dpy, bitmap)
struct LLDisplay *dpy; 
Pixmap bitmap;{
	XFreePixmap (dpy->display, bitmap);
}
 
bitblit (dpy, pixmap1, pixmap2, x1, y1, x2, y2, w, h, gc)
struct LLDisplay *dpy; 
Drawable pixmap1, pixmap2;
GC gc;
int x1, y1, x2, y2;
unsigned int w, h;{
	if ((w > 0) && (h > 0))
 		XCopyArea (dpy->display, pixmap2, pixmap1, gc, 
 			   x2, y2, w, h, x1, y1);
}

set_bit_line (dpy, pixmap, x, y, string, w)
struct LLDisplay *dpy; 
Drawable pixmap;
int x, y;
char *string;
int w;{
	if (w > 0){
		dpy->setimage->data = string;
		XPutImage (dpy->display, pixmap, dpy->fullgc, dpy->setimage,
			   0, 0, x, y, w, 1);
	}
}

get_bit_line (dpy, pixmap, x, y, string, w)
struct LLDisplay *dpy; 
Drawable pixmap;
int x, y;
char *string;
int w;{
	XImage *getimage;
	int i;
	int comb;
	int plane;
	int mask;
	
	comb= dpy->ForePixel ^ dpy->BackPixel;
	for (i = 0 ; i < dpy->depth ; i++)
		if ( comb & 1<<i ) plane= 1<<i;
	if (w > 0){
		mask = 0;
 		getimage = XGetImage (dpy->display, pixmap, x, y, w, 1, plane,
			   	      XYPixmap);
		if (plane ^ dpy->ForePixel ) mask = 0xff;  
		for (i = 0; i < ((w+15)/16)*2; i++)
			string [i] = mask ^ getimage->data [i];
		XDestroyImage (getimage);
	}
}

int bmref (dpy, pixmap, x, y)
struct LLDisplay *dpy; 
Drawable pixmap;
int x, y;{
	XImage *getimage;
	int bit;
	int comb;
	int plane;
	int i;

	comb= dpy->ForePixel ^ dpy->BackPixel;
	for (i = 0 ; i < dpy->depth ; i++)
		if ( comb & 1<<i ) plane= 1<<i;
	getimage = XGetImage (dpy->display, pixmap, x, y, 1, 1, plane
			      , XYPixmap);
	bit = XGetPixel (getimage, 0, 0);
	if (plane ^ dpy->ForePixel)
		bit = !bit;
	XDestroyImage (getimage);
	return (bit);
}

bmset (dpy, pixmap, x, y, bit)
struct LLDisplay *dpy; 
Drawable pixmap;
int x, y;
int bit;{
	dpy->setimage->data = EMPTYSTRING;
	XPutPixel (dpy->setimage, 0, 0, bit);
	XPutImage (dpy->display, pixmap, dpy->fullgc, dpy->setimage,
		   0, 0, x, y, 1, 1); 
}

set_byte_line (dpy, pixmap, x, y, string, w)
struct LLDisplay *dpy; 
Drawable pixmap;
int x, y;
char *string;
int w;{
	if (w > 0){
		dpy->setcolorimage->data = string;
		XPutImage (dpy->display, pixmap, dpy->fullgc, 
			   dpy->setcolorimage,
			   0, 0, x, y, w, 1);
	}
}

get_byte_line (dpy, pixmap, x, y, string, w)
struct LLDisplay *dpy; 
Drawable pixmap;
int x, y;
char *string;
int w;{
	XImage *getimage;
	int i;
	if (w > 0){
 		getimage = XGetImage (dpy->display, pixmap, x, y, w, 1, 255,
			   	      ZPixmap);
		for (i = 0; i < w; i++)
			string [i] = getimage->data [i];
		XDestroyImage (getimage);
	}
}


int byteref (dpy, pixmap, x, y)
struct LLDisplay *dpy; 
Drawable pixmap;
int x, y;{
	XImage *getimage;
	int bit;
	getimage = XGetImage (dpy->display, pixmap, x, y, 1, 1, 255, ZPixmap);
	bit = XGetPixel (getimage, 0, 0);
	XDestroyImage (getimage);
	return (bit);
}

byteset (dpy, pixmap, x, y, bit)
struct LLDisplay *dpy; 
Drawable pixmap;
int x, y;
int bit;{
	dpy->setcolorimage->data = EMPTYSTRING;
	XPutPixel (dpy->setcolorimage, 0, 0, bit);
	XPutImage (dpy->display, pixmap, dpy->fullgc, dpy->setcolorimage,
		   0, 0, x, y, 1, 1); 
}



Pixmap pixmap_to_bitmap (dpy, pixmap, w, h)
struct LLDisplay *dpy;
Pixmap pixmap;
int w, h; {
	Pixmap bitmap;
	GC monoplanegc;
	XGCValues values;
	
	bitmap = XCreatePixmap (dpy->display, dpy->root, w, h, 1);
	values.graphics_exposures = False;
	monoplanegc = XCreateGC (dpy->display, bitmap, GCGraphicsExposures, 
				 &values);
	XCopyPlane (dpy->display, pixmap, bitmap, monoplanegc,
		    0, 0, w, h, 0, 0, dpy->monoplane);
	XFreeGC(dpy->display, monoplanegc);
	return (bitmap);
}

Cursor create_cursor (dpy, cursor)
struct LLDisplay *dpy;
int cursor; {
	return (XCreateFontCursor (dpy->display, cursor));
}

Cursor make_cursor (dpy, pixmap1, pixmap2, fgr, fgg, fgb,
		    bgr, bgg, bgb, x, y)
struct LLDisplay *dpy; 
Pixmap pixmap1, pixmap2;
int fgr, fgg, fgb, bgr, bgg, bgb;
int x, y;{
	XColor fore, back;
	
	fore.red = 2*fgr;
	fore.green = 2*fgg;
	fore.blue = 2*fgb;
	back.red = 2*bgr;
	back.green = 2*bgg;
	back.blue = 2*bgb;
        return (XCreatePixmapCursor (dpy->display, pixmap1, pixmap2,
                                     &fore, &back, x, y)) ;
}

current_cursor (dpy, window, cursor)
struct LLDisplay *dpy; 
Window window;
Cursor cursor;{
	XDefineCursor (dpy->display, window, cursor); 
}

move_cursor (dpy, x2, y2)
struct LLDisplay *dpy; 
int x2, y2;{
	XWarpPointer (dpy->display, None, dpy->root, 0, 0, 0, 0, x2, y2);
}

/* ************************************************************************* */
/*                               La Couleur                                  */
/* ************************************************************************* */

int make_color (dpy, r, g, b, color) 
struct LLDisplay *dpy;
int r, g, b;
struct LLColor *color; {
	XColor xcolor;

	xcolor.red = 2*r;
	xcolor.green= 2*g;
	xcolor.blue = 2*b;
	if (XAllocColor (dpy->display, dpy->colormap, &xcolor) == NULL)
      		 return (-1);
	color->red = xcolor.red / 2;
	color->green = xcolor.green / 2;
	color->blue = xcolor.blue / 2;
	return (xcolor.pixel);
}

int make_mutable_color (dpy, r, g, b)
struct LLDisplay *dpy;
int r, g, b; {
	XColor xcolor;
	
	if (XAllocColorCells (dpy->display, dpy->colormap, 
			      0, 0, 0, &xcolor.pixel, 1) == NULL)
		return (-1);
	
	xcolor.red = 2*r;
	xcolor.green= 2*g;
	xcolor.blue = 2*b;
	xcolor.flags = DoRed|DoGreen|DoBlue;
	XStoreColor (dpy->display, dpy->colormap, &xcolor);
	
	return (xcolor.pixel);
}

int make_named_color (dpy, name, color) 
struct LLDisplay *dpy;
char *name; 
struct LLColor *color; {
	XColor xcolor;

	if (XParseColor (dpy->display, dpy->colormap, name, &xcolor) == NULL)
 		return (-1);
	if (XAllocColor (dpy->display, dpy->colormap, &xcolor) == NULL)
		return (-1);
	color->red = xcolor.red / 2;
	color->green = xcolor.green / 2;
	color->blue = xcolor.blue / 2;
	return (xcolor.pixel);
}

kill_color (dpy, pix) 
struct LLDisplay *dpy;
int pix; {
	XColor color;
	color.pixel = pix;
	XFreeColors (dpy->display, dpy->colormap, &color, 1, 0);
}

current_foreground (dpy, pix) 
struct LLDisplay *dpy;
int pix; {
    XSetForeground(dpy->display, dpy->currentgc, pix);
    XSetForeground(dpy->display, dpy->fullgc, pix);
}

current_background (dpy, pix) 
struct LLDisplay *dpy;
int pix; {
    XSetBackground(dpy->display, dpy->currentgc, pix);
    XSetBackground(dpy->display, dpy->fullgc, pix);
    XSetWindowBackground (dpy->display, dpy->currentwindow, pix);
}

int color_component (dpy, pix, red, green, blue, flag)
struct LLDisplay *dpy; 
int pix;
int red, green, blue, flag; {
	XColor color;

	color.red = 2*red;
	color.green = 2*green;
	color.blue = 2*blue;
	color.pixel = pix;
	switch (flag) {
	case 0: 
		color.flags = DoRed;
		break;
	case 1: 
		color.flags = DoGreen;
		break;
	case 2: 
		color.flags = DoBlue;
		break;
	}
	XStoreColor (dpy->display, dpy->colormap, &color);
	return 1;
}

char *get_default (dpy, prog, item)
struct LLDisplay *dpy; 
char *prog, *item; {
	char *res;
       	res = XGetDefault (dpy->display, prog, item);
	return res ? res : "";
}

set_menu_attributes (dpy, window)
struct LLDisplay *dpy; 
Window window; {
	XSetWindowAttributes xswa;
	
	xswa.override_redirect = True;
	xswa.save_under = True;
	XChangeWindowAttributes (dpy->display, window,
				 CWOverrideRedirect|CWSaveUnder,
				 &xswa);
}

/* ************************************************************************* */
/* Cause Bug X11R2 : La CURSOR Fonte n'est pas liberee au XCloseDisplay      */
/*                   et mal reallouee au XCreateFontCursor                   */
/* ************************************************************************* */
/* ****               Correction non testee en X11R3                    **** */
/* ************************************************************************* */

#ifdef x11r2
#define CURSORFONT "cursor"
Cursor XCreateFontCursor(dpy, which)
Display *dpy;
unsigned int which;
{
	static XColor foreground = { 0,    0,     0,     0  }; 
	static XColor background = { 0, 65535, 65535, 65535 }; 
	static Font cfont;
	
	cfont = XLoadFont(dpy, CURSORFONT);
	return (XCreateGlyphCursor (dpy, cfont, cfont, which, which + 1,
				    &foreground, &background));
}
#endif x11r2

synchronize (dpy, onoff)
Display *dpy;
int onoff;
{
	XSynchronize(dpy, onoff);
}

/* ************************************************************************* */
