(*
$File: Compiler/AND_OR_TREE.sml $
$Date: 1992/09/17 14:17:40 $
$Revision: 1.1 $
$Locker:  $
*)

(*$AND_OR_TREE*)
signature AND_OR_TREE =
  sig
    eqtype (*pah!*) RuleNum sharing type RuleNum = int

    type pat				(* From abstract syntax: patterns. *)
    type lab				(* Record/tuple labels. *)
    type TypeInfo			(* Hints to enumerate labs/cons. *)
    type con				(* Constructors. *)
    type longexcon			(* Exception constructors. *)
    type scon				(* Special constants (literals). *)
    type var				(* Non-constructor identifiers. *)
    type (''a, 'b) map			(* Finite maps (from FinMap). *)


    datatype NodeInfo =
      NODEINFO of {rules: RuleNum EqSet.Set, defaults: RuleNum EqSet.Set}

   (* Note that EXCON subdivides using a list, not a map. This is because
      we have to test the exceptions in strict top-to-bottom order. The list
      is held in reverse order (last rule to first) since it's easier to
      build it that way. *)

    datatype AndOrTree = TUPLE of {nodeInfo: NodeInfo,
				   children: (lab, TypeInfo * AndOrTree) map
				  }
                       | CON of {nodeInfo: NodeInfo,
				 children: (con, TypeInfo * AndOrTree) map
				}
		       | SCON of {nodeInfo: NodeInfo,
				  children: (scon, AndOrTree) map
				 }
		       | EXCON of {nodeInfo: NodeInfo,
				   children: (longexcon * AndOrTree) list
				  }
		       | LEAF of NodeInfo


    val buildAndOrTree: pat list -> AndOrTree
					(* pat list != nil. *)

    type StringTree
    val layoutAndOrTree: AndOrTree -> StringTree
  end;
