(* Type information for match compiler *)

(*
$File: Common/TypeInfo.sml $
$Date: 1991/11/08 13:18:57 $
$Revision: 1.12 $
$Locker: birkedal $
*)

(*$TypeInfo: LAB CON CRASH TYPE_INFO *)

functor TypeInfo(type lab and longcon
		 structure PP: PRETTYPRINT
		): TYPE_INFO =
  struct
    type lab = lab
    type longcon = longcon

    datatype info = LAB_INFO of {index: int}
		  | CON_INFO of {numCons: int, index: int, functional: bool}
		  | EXCON_INFO of {functional: bool}

    type StringTree = PP.StringTree
    fun layoutInfo info =
      case info
	of LAB_INFO{index} => PP.LEAF("LAB_INFO(" ^ Int.string index ^ ")")

	 | CON_INFO{numCons, index, functional} =>
	     PP.NODE{start="CON_INFO(",  finish=")", indent=2,
		     children=[PP.LEAF("numCons: " ^ Int.string numCons),
			       PP.LEAF("index: " ^ Int.string index),
			       PP.LEAF("functional: " ^
				       (case functional of true  => "T"
					  	         | false => "F"
				       )
				      )
			      ],
		     childsep=PP.RIGHT ", "
		    }

         | EXCON_INFO{functional} =>
	     PP.LEAF("EXCON_INFO(func=" ^ (case functional of true => "T"
						            | false => "F"
					  ) ^ ")"
		    )
  end;
