(* Derived form information *)

(*
$File: Common/DFInfo.sml $
$Date: 1992/01/29 14:57:48 $
$Revision: 1.8 $
$Locker: birkedal $
*)

(*$DFInfo: PRETTYPRINT DF_INFO*)

functor DFInfo(structure PP: PRETTYPRINT) : DF_INFO =
  struct
    datatype info = UNITEXP_df | TUPLE_df | CASE_df | IF_df | ORELSE_df
      		  | FUN_df | VALIT_df | INFIX_df

    type StringTree = PP.StringTree

    fun layoutInfo info =
      PP.LEAF(case info
		of UNITEXP_df => "UNITEXP"
		 | TUPLE_df   => "TUPLE"
		 | CASE_df    => "CASE"
		 | IF_df      => "IF_df"
		 | ORELSE_df  => "ORELSE_df"
		 | FUN_df     => "FUN_df"
		 | VALIT_df   => "VALIT_df"
		 | INFIX_df   => "INFIX_df"
	     )
  end;
