/*
 * term.h: header file for term.c 
 *
 * Copyright 1990 Michael Sandrof
 * Copyright 1997 EPIC Software Labs
 * Copyright 1998 J. Kean Johnston
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#ifndef __term_h__
#define __term_h__

/* To get declaration of "current_screen" */
#include "screen.h"

extern	int	need_redraw;
extern	int	meta_mode;

/* 
 * This puts a character to the current target, whatever it is. 
 * All output everywhere should go through this.
 * This does not mangle its output, so its suitable for outputting
 * escape sequences.
 */
#if !defined(WTERM_C) && !defined(WSERV_C)
#define current_ftarget (output_screen ? output_screen->fpout : stdout)

__inline__ 
static int putchar_x (int c) { return fputc((int) c, current_ftarget); }

__inline__
static void term_flush (void) { fflush(current_ftarget); }
#endif

#define	TERM_SGR_BOLD_ON	1
#define TERM_SGR_BOLD_OFF	2
#define TERM_SGR_BLINK_ON	3
#define TERM_SGR_BLINK_OFF	4
#define TERM_SGR_UNDL_ON	5
#define TERM_SGR_UNDL_OFF	6
#define TERM_SGR_REV_ON		7
#define TERM_SGR_REV_OFF	8
#define TERM_SGR_NORMAL		9
#define TERM_SGR_RESET		10
#define TERM_SGR_FOREGROUND	11
#define TERM_SGR_BACKGROUND	12
#define TERM_SGR_GCHAR		13
#define TERM_SGR_MAXVAL		14

#define TERM_CAN_CUP		1 << 0
#define TERM_CAN_CLEAR		1 << 1
#define TERM_CAN_CLREOL		1 << 2
#define TERM_CAN_RIGHT		1 << 3
#define TERM_CAN_LEFT		1 << 4
#define TERM_CAN_SCROLL		1 << 5
#define TERM_CAN_DELETE		1 << 6
#define TERM_CAN_INSERT		1 << 7
#define TERM_CAN_DELLINES	1 << 8
#define TERM_CAN_INSLINES	1 << 9
#define TERM_CAN_REPEAT		1 << 10
#define TERM_CAN_BOLD		1 << 11
#define TERM_CAN_BLINK		1 << 12
#define TERM_CAN_UNDL		1 << 13
#define TERM_CAN_REVERSE	1 << 14
#define TERM_CAN_COLOR		1 << 15
#define TERM_CAN_GCHAR		1 << 16

extern	char	*TI_cr, *TI_nl;
extern	int	TI_lines, TI_cols;
extern	char	*TI_sgrstrs[];
extern	char	*TI_forecolors[];
extern	char	*TI_backcolors[];
extern	int	termfeatures;

#define term_has(x) 	(termfeatures & (x))
#define capstr(x) 	(TI_sgrstrs[(TERM_SGR_ ## x)-1])
#define outcap(x)	(tputs_x(capstr(x)))

#ifndef TERM_DEBUG
#define tputs_x(s)		(tputs(s, 0, putchar_x))
#else
int	tputs_x(char *);
#endif
#define term_underline_on()	outcap(UNDL_ON)
#define term_underline_off()	outcap(UNDL_OFF)
#define term_standout_on()	outcap(REV_ON)
#define term_standout_off()	outcap(REV_OFF)
#define term_blink_on()		outcap(BLINK_ON)
#define term_blink_off()	outcap(BLINK_OFF)
#define term_bold_on()		outcap(BOLD_ON)
#define	term_bold_off()		outcap(BOLD_OFF)
#define term_set_foreground(x)	tputs_x(TI_forecolors[(x) & 0x0f])
#define term_set_background(x)	tputs_x(TI_backcolors[(x) & 0x0f])
#define term_set_attribs(f,b)	tputs_x(term_getsgr(TERM_SGR_COLORS,(f),(b)))
#define term_putgchar(x)	tputs_x(term_getsgr(TERM_SGR_GCHAR,(x),0))
#define term_clear_screen()	term_clrscr()
#define term_move_cursor(c, r)	term_gotoxy((c),(r))
#define term_cr()		tputs_x(TI_cr)
#define term_newline()		tputs_x(TI_nl)
#define term_cursor_left()	term_left(1)
#define term_cursor_right()	term_right(1)
#define term_clear_to_eol()	term_clreol()


	RETSIGTYPE 	term_cont 		(int);
	void 		term_beep 		(void);
	int		term_echo 		(int);
	int		term_init 		(void);
	int		term_resize 		(void);
	void		term_pause 		(char, char *);
	void		term_putchar 		(unsigned char);
	void		term_scroll 		(int, int, int);
	void		term_insert 		(unsigned char);
	void		term_delete 		(int);
	void		term_repeat		(unsigned char, int);
	void		term_right		(int);
	void		term_left		(int);
	void		term_clreol		(void);
	void		term_clrscr		(void);
	void		term_gotoxy		(int, int);
	void		term_reset		(void);
	int		term_eight_bit		(void);
	void		set_term_eight_bit	(int);
	void		set_meta_8bit		(int);
	char *		term_getsgr		(int, int, int);

#endif /* _TERM_H_ */
