 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: spectrum.h
 >>>>            Author: Danielle Argiro
 >>>> Date Last Updated: Wed Oct  2 17:10:46 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _spectrum_h_
#define _spectrum_h_

#include "xvinclude.h"


/* -include_includes */
#include "xvforms.h"
#include "form_info.h"
#include "xvdisplay.h"
#include "xvgraphics.h"
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    spectrum Argument Structure
*
****************************************************************/

typedef struct _spectrum  {

/*
 *  input image filename (Optional infile)
 */
char	*i;     	/* input image filename FILENAME */
int	 i_flag;	/* input image filename FLAG */

/*
 *  input legend filename (Optional infile)
 */
char	*l;     	/* input legend filename FILENAME */
int	 l_flag;	/* input legend filename FLAG */

}  spectrum_struct;

spectrum_struct *spectrum;

/* -include_additions */

/* ========= structures ========= */

/*
 * structure holding information about zoom workspace
 */
typedef struct
{
        int     focus;
        XImage *ximage;
        Widget  raster;
        Widget  position;
        float   zoomfactor;
        int     cursor;

        struct  xvimage *assoc_image;
        Widget  assoc_raster;
        XImage  *assoc_ximage;
        int     xpos, ypos;
        int     xoffset, yoffset;

        int     min_x, min_y;
        int     x_zoom_loc, y_zoom_loc;

} ZoomStructure;

ZoomStructure *zoom;

/*
 * structure holding information about scroll bars
 */
typedef struct
{
        int      id;
        double   num;
        char     *string;
        unsigned long pixel;

        Widget   value;
        Widget   scrollbar;
}  ScrollStruct;

/*
 * structure holding information the X color elements.  Before
 * any of the display utilites change the color aray they push
 * the color structures onto the "color" stack, so that the user
 * has the option to pop or "undo" the coloring operations.
 */
typedef struct _color_stack
{
        int     index1, index2;

        XColor  *xcolors;
        struct  _color_stack *prev;
} ColorStack;


/*
 *  keeps track of legend information for a particular class
 */
typedef struct _legend_list  {

        short class;      /* class id number                      */
        short red;        /* red value of color assoc. w/ class   */
        short green;      /* green value of color assoc. w/ class */
        short blue;       /* blue value of color assoc. w/ class  */
        char  *text;      /* text associated w/ class             */
        int   clusternum; /* number of clusters in class          */
        int   *clusters;  /* cluster numbers in class             */
        int   hidden;     /* TRUE if assoc. color not displayed   */

        struct _legend_list *next;
        struct _LegendEntry *entry_ptr;

        } legend_list;

legend_list *spc_legend_list;
legend_list **spc_legend_lookup;

/*
 * structure for Legend callbacks - keeps information 
 * about a single set of widgets in the viewport, where the
 * viewport contains sets of widgets including a color box,
 * a widget showing the current RGB value of color in the box,
 * and a command widget containing the text assoc. w/ that 
 * legend entry.
 */
typedef struct _LegendEntry {

        Widget back;            /* backplane of legend entry widget set       */
        Widget colorbox;        /* box displaying the current color for entry */
        Widget RGBwid;          /* widget displaying RGB values of color      */
        Widget textwid;         /* widget displaying text assoc. w/ entry     */

        legend_list *legend_ptr; /* pointer to info about legend entry        */
        int    widrepcount;     /* used as minor part of backplane's name     */
        } LegendEntry;

LegendEntry *current_entry;

/*
 * structure for Legend display as a whole -
 * keeps information that is global to the 
 * entire Legend display.
 */
typedef struct _LegendStruct {

        Widget color1, color2;  /* color boxes used to set range              */
        int    widcount;        /* used as major part of backplane's name     */

        Widget viewback;        /* backplane on viewport                      */
        Widget rgb_back,        /* backplanes for each colorspace's scrolls   */
               cmy_back, hsv_back, hls_back,
               yiq_back, xyz_back, uvw_back, grey_back;

        ScrollStruct rgb[3], cmy[3], /* information for each scroll bar       */
                     hsv[3], hls[3],
                     grey[3];

        } LegendStruct;

LegendStruct *display_ptr;


/*
 *  structure for Print Class feature
 */

typedef struct _printclass {
        Widget colorbox;
        Widget labelwid;
        Widget RGBwid;
        Widget clusterwid;
        Widget canvas;
        int    mode;
        } printclass_struct;
printclass_struct *spc_printclass;

#define SpcPCid 2

/* ========= #defines ========= */

/* 
 * graphics id for scatter plot, expression id 
 * graphics id for axes on scatter plot
 */
#define SpcId           1   

/* 
 * red band, green band, blue band 
 */
#define SpcRed   1   
#define SpcBlue  2
#define SpcGreen 3

/* 
 *  changing column displayed as X or Y in plot 
 */
#define SpcX   1
#define SpcY  2

/* 
 * current colorspace 
 */
#define SpcRGB  1       
#define SpcCMY  2
#define SpcHSV  3
#define SpcHLS  4
#define SpcGREY 5

/* 
 * contents of map data 
 */
#define SpcMeanVectors  0               
#define SpcCount       (1L << 0)
#define SpcClass       (1L << 1)
#define SpcCovarMatrix (1L << 2)
#define SpcCovarDiag   (1L << 3)


/* 
 * number of colors used by scatter plot
 */
#define SpcPlotColornum 5

/* 
 * operation performed with scatter plot
 */
#define SpcDelete 0
#define SpcAdd    1

/* 
 * maximum number of classes supported
 */
#define MaxClasses 256

/* 
 * different possibities wrt legend   
 */
#define SpcAll       1
#define SpcHidden    2
#define SpcDisplayed 3
#define SpcNotEmpty  4

/*
 *  defines for Normalization Methods
 */

/* spc_norm_type will be one of: */
#define SpcNormLocal  0
#define SpcNormGlobal 1
#define SpcNormOFF    2

/* spc_norm_time will be one of: */
#define SpcNormWhenNecc 0
#define SpcNormAlways   1

/* spc_norm_method will be one of: */
#define SpcNormWithinColors   0
#define SpcNormWithinStdDev   1

/*
 *  defines for Zoom
 */
#define  ZoomDisplayWidth  200
#define  ZoomDisplayHeight 200

/* ========= global variables ========= */

xvf_form  *form;                /* pointer to form tree */
Display *display;               /* global display */
struct xvimage *spc_image;      /* image being displayed */
DisplayStructure *xvdisplay;    /* global xvdisplay structure */
master master_info;             /* mediating structure btwn xvforms & appl */
GC gc_zoom;                     /* Graphics Context structure for Zoom */

Widget  spc_workspace,          /* widget on which image is displayed */
        class_workspace,        /* widget on which current class is displayed */
        legend_workspace,       /* widget on which legend is displayed */
        plot_workspace,         /* widget on which plot is displayed */
        zoom_workspace,         /* widget on which zoom is displayed */
        plot_pos_widget;        /* widget on which plot position is displayed */

XColor PlotColors[SpcPlotColornum]; /* colors used for plot */

int    spc_lgd_classes[MaxClasses];     /* keeps track of classes in legend */
int    spc_lgd_classnum;                /* number of classes in legend */
int    spc_img_classes[MaxClasses];     /* keeps track of classes in image */
int    spc_img_classnum;                /* number of classes in image */

int    spc_color_model;  /* indicates current color model */
int    spc_max_colors;   /* maximum # colors that can be displayed */
int    spc_norm_type;    /* automatically normalize colors? Local, Global, Off*/
int    spc_norm_time;    /* when to normalize? always ? or only when necc. ? */
int    spc_norm_method;  /* how to normalize? btwn 0 & 255, mean & std dev */

float  **spc_map;         /* map data representing codebook */
int    spc_map_colnum;    /* # cols in the map data (image->ispare2)*/
int    spc_map_rownum;    /* # rows in the map data */
int    spc_unique_values; /* unique values in the map data */
long   spc_map_contents;  /* masking gives contents of codebook data in map */
int    spc_matrix_size;   /* # cols in the covariance matrix */
int    spc_diag_size;     /* # cols in the covariance diagonal */
float  **spc_covar_matrix; /* stores the covariance matrix */
float  **spc_covar_diag;   /* stores the covariance diagonal */

int    *spc_unused_classnums;    /* array of unused class numbers (holes) */
int    spc_num_unused_classnums; /* number of holes (size of array) */

int    *spc_classes;    /* cluster as index, class it belongs to as elem */
int    *spc_count;      /* count array */

float  *spc_x_col, *spc_y_col; /* point to X & Y data currently plotted */
short  *spc_x_dcs, *spc_y_dcs; /* point to DC's of X & Y data plotted */
int    *spc_plot_indices;    /* cluster # indexes element w/ plot data index */
int    *spc_plot_rev_indices;   /* plot data indexes element w/ cluster # */

unsigned long   white, black, grey,  /* colors used w/ legend display */
                red, green, blue,
                cyan, magenta, yellow;

int   spc_plot_operation;            /* adding or deleting clusters from plot */
int   spc_prop_plotting;             /* proportional plotting? */
float spc_actual_plot_zoomfactor;     /* actual zoom factor of plot */
float spc_potential_plot_zoomfactor;  /* potential zoom factor of plot */
float plot_x_focus, plot_y_focus;     /* middle of plot */
int   spc_draw_plot_zoombox;          /* whether to draw zoom area on plot */

char *current_red_func,         /* current function for red band   */
     *current_green_func,       /* current function for green band */
     *current_blue_func;        /* current function for blue band  */

float *current_red_col,         /* current map column for red band   */
      *current_green_col,       /* current map column for green band */
      *current_blue_col;        /* current map column for blue band  */

float *norm_red_col,            /* normalized map column for red band   */
      *norm_green_col,          /* normalized map column for green band */
      *norm_blue_col;           /* normalized map column for blue band  */

Coord *spc_plot_points; /* array of current points to plot */
Coord spc_wcmin;        /* minimum Coord of current points to plot */
Coord spc_wcmax;        /* maximum Coord of current points to plot */

float spc_min,   spc_max;    /* min & max of all 3 displayed columns */
float red_min,   red_max;    /* min & max of red column */
float green_min, green_max;  /* min & max of green column */
float blue_min,  blue_max;   /* min & max of blue column */

/* ========= function definitions ========= */

char *malloc(), *realloc();

char **create_mapcol_list();
char **create_category_list();
char **variable_scan();
char *create_function_def();
char *create_function_call();
int  *parse_legend_info();
int  *construct_legend_info();

void  update_printclass();
void  update_zoom_position();
void  redisplay_zoom();
void  spc_zoom();
void  add_cluster_from_img();

float **read_normal_map(), **read_interleaved_map();
float *perform_map_function();
float *perform_plot_function();
float *copy_column();
legend_list *find_legend_from_text();

void legend_colorbox_cb();
void legend_textwid_cb();

void update_legend_incr();
void update_legend_cont();
void update_scroll();

void draw_plot();
void update_plot_focus();
void highlight_cursor_position();

Widget create_legend_scrollbars();
Widget create_legend_scrollbar();

legend_list *add_legend_node();

/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
