 /*
  * Khoros: $Id: run_roi.c,v 1.1 1991/05/10 15:58:30 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_roi.c,v 1.1 1991/05/10 15:58:30 khoros Exp $";
#endif

 /*
  * $Log: run_roi.c,v $
 * Revision 1.1  1991/05/10  15:58:30  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "editimage.h"

/********************************************************
*
*  Routine Name:  run_roi
*
*       Purpose:  drives the pane 'roi'
*
*         Input:  form - pointer to the form tree 
*		  roi_info  - information structure for pane 'roi'
*        Output:  action of the application program
*
*     Called By:  run_function()
*
*   Automatically Generated By:  conductor
*
********************************************************/


run_roi(form, roi_info)

xvf_form *form;
roi_subform_roi *roi_info;
{
	char   *filename, temp[MaxLength];
	struct xvimage *image, *readimage();

#include "roi.h"  /* contains the static char 'commands' and 'options' arrays */

	if (xvdisplay->image == NULL)
	{
	    xvf_error_wait("Please display an image before attempting a region of interest operation!", "run_roi", NULL);
	    return;
	}

	_xvf_get_roi(form, roi_info);

	/*
	 * user clicked on 'live' input file selection 'insert'
	 */
	if (roi_info->insert_selected)
	{
	    if (!(filename = vfullpath(roi_info->insert, global_indir, NULL)))
            {
            	xvf_error_wait("Error!  No filename specified.", 
				"run_roi", NULL);
                return;
            } 
	    /*
             *  read in the image.
             */
            if (!(image = readimage(filename)))
            {
               /* error in readimage */
               sprintf(temp, "Unable to read image from file %s",
		       filename);
               xvf_error_wait(temp, "run_roi", NULL);
               free(filename); return;
            }

	    /* insert using mouse */
	    if (roi_info->place_val == 0)
            {
                xvd_insert_roi(xvdisplay, image, True, roi_info->x,
				roi_info->y, NULL);
	    }

	    /* insert using position parameters */
            else if (roi_info->place_val == 1)
	    {
                xvd_insert_roi(xvdisplay, image, False, roi_info->x,
				roi_info->y, NULL);
	    }

            freeimage(image);
	    set_colormap();
	    refresh_displays(0, MAX_PIXELS);
	    sprintf(temp, "Region of interest read from file '%s'",filename);
            xvf_error_wait(temp, "run_overlays", NULL);
	}

	/*
	 * user clicked on 'live' output file selection 'extract'
	 */
	else if (roi_info->extract_selected)
	{
	    if (!(filename = vfullpath(roi_info->extract, global_outdir, NULL)))
            {
           	xvf_error_wait("Error!  No filename specified.","run_roi",NULL);
           	return;
            }
	    /* extract using mouse */
	    if (roi_info->place_val == 0) 
            {
           	if (!(image = xvd_extract_roi(xvdisplay, True, 
					roi_info->x, roi_info->y, 
					roi_info->x + roi_info->width, 
					roi_info->y + roi_info->height)))
                     return;
            }

	    /* extract using position parameters */
            else if (roi_info->place_val == 1)
            {
                if (!(image = xvd_extract_roi(xvdisplay, False, 
					  roi_info->x, roi_info->y, 
					  roi_info->x + roi_info->width,
					  roi_info->y + roi_info->height)))
              	    return;
            }


            if (!writeimage(filename, image))
            {
               sprintf(temp, "Unable to write image to file %s", filename);
               xvf_error_wait(temp, "run_roi", NULL);
	       return;
            }
            freeimage(image); free(filename);
	    sprintf(temp, "Region of interest written to file '%s'",filename);
            xvf_error_wait(temp, "run_overlays", NULL);
	}

	/*
	 * user clicked on pane action button 'commands'
	 */
	else if (roi_info->commands)
	{
	    roi_command *roi;
            XawListReturnStruct *entry;

	    int     i, num, current, use_system;
            char    *infile  = NULL,
		    *outfile = NULL,
		    *labels[MaxLength],
		     buffer[MaxLength];

	    char   *label  = "Choose a command for Region of Interest",
		   *prompt = "ROI Commands:";

 
	    /*
	     *  Get the labels for each of the roi commands and assign them
	     *  in an array so that the user can choose which command they
	     *  want.
	     */
	    num = XtNumber(commands);
	    for (i = 0; i < num; i++)
		labels[i] = commands[i].label;

	    if (!(entry = xvf_run_list_wait(labels, num, 3, prompt, label,
			&current, True)))
	    {
                 return;
	    }

            if (entry->list_index != -1)
            {
		roi = &commands[entry->list_index];
		if (roi_info->options == 0)
	        {
		   use_system = False;
           	   (void) sprintf(buffer,"%s %s ", roi->command, roi->options);
		}
		else
		{
		   use_system = True;
           	   (void) sprintf(buffer,"xterm -e /bin/csh -c \" (%s ",
					roi->command);
		}
		if (roi->input != NULL)
		{
		   infile = vtempnam("roi_input");
		   (void) sprintf(temp,"%s %s ", roi->input, infile);
		   (void) strcat(buffer, temp);
		}
		if (roi->output != NULL)
		{
		   outfile = vtempnam("roi_output");
		   (void) sprintf(temp,"%s %s ", roi->output, outfile);
		   (void) strcat(buffer, temp);
		}

		if (roi_info->options == 1)
		{
		   if (roi->output == NULL)
		      (void) strcat(buffer," -P ; echo ; echo -n hit return to continue ; set input $< )\" ");
		   else
		      (void) strcat(buffer,"-P )\" -e ");
		}
            }
            else
            {
		use_system = False;
                infile  = vtempnam("roi_input");
                outfile = vtempnam("roi_output");
           	(void) sprintf(buffer,"cat %s | %s > %s", 
			       infile, entry->string, outfile);
            }

	    /* extract using mouse */
	    if (infile != NULL)
	    {
               if (roi_info->place_val == 0)
               {
           	   if (!(image = xvd_extract_roi(xvdisplay, True,
				        roi_info->x, roi_info->y,
				        roi_info->x + roi_info->width, 
				        roi_info->y + roi_info->height)))
                       return;
               }
	       /* extract using position parameters */
               else if (roi_info->place_val == 1)
               {
           	   if (!(image = xvd_extract_roi(xvdisplay, False,
				        roi_info->x, roi_info->y,
					roi_info->x + roi_info->width, 
					roi_info->y + roi_info->height)))
              	       return;
               }


              if (!writeimage(infile, image))
              {
                 sprintf(temp, "Unable to write image to file %s", infile);
                 xvf_error_wait(temp, "run_roi", NULL);
	         return;
	      }
	    }

	    if (use_system)
	       system(buffer);
	    else
	       xvf_system(buffer);

	    /*
	     *  Check to see if we need to free the infile.
	     */
            if (infile != NULL)
	    {
	       unlink(infile);  free(infile);
	    }

	    /*
	     *  Check to see if there was an outfile, if so then get it
	     *  and import it into the display image.
	     */
	    if (outfile != NULL)
	    {
               image = readimage(outfile);
               if (image != NULL)
               {
                   xvd_insert_roi(xvdisplay, image, True, roi_info->x,
				roi_info->y, NULL);
           	   freeimage(image);
		   set_colormap();
		   refresh_displays(0, MAX_PIXELS);
               }
	       unlink(outfile); free(outfile);
	    }
	}

} /* end run_roi */
