/* $XConsortium: Xlib.h,v 11.179 89/12/12 13:57:19 jim Exp $ */
/* 
 * Copyright 1985, 1986, 1987 by the Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of M.I.T. not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission. M.I.T. makes no representations about the 
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The X jp_long System is a Trademark of MIT.
 *
 */


/*
 *	Xlib.h - Header definition and support file for the C subroutine
 *	interface library (Xlib) to the X jp_long System Protocol (V11).
 *	Structures and symbols starting with "_" are private to the library.
 */
#ifndef _JPEvent_h_
#define _JPEvent_h_

/*
 * A "JPEvent" structure always  has type as the first entry.  This 
 * uniquely identifies what  kind of event it is.  The second entry
 * is always a pointer to the display the event was read from.
 * The third entry is always a window of one type or another,
 * carefully selected to be useful to toolkit dispatchers.  (Except
 * for keymap events, which have no window.) You
 * must not change the order of the three elements or toolkits will
 * break! The pointer to the generic event must be cast before use to 
 * access any other information in the structure.
 */

/*
 *  int     jp_int
 *  long    jp_long
 *  Bool    jp_int
 *  Time    jp_long
 *  Window  jp_long
 *  Atom    jp_long
 *  XID     jp_long
 *  short   jp_short
 */

typedef char jp_int[4];
typedef char jp_long[4];
typedef char jp_short[2];
typedef char jp_addr[4];
 
/*
 * Definitions of specific events.
 */
typedef struct {
	jp_int type;		/* of event */
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;		/* "event" window it is reported relative to */
	jp_long root;		/* root window that the event occured on */
	jp_long subwindow;	/* child window */
	jp_long time;		/* milliseconds */
	jp_int x, y;		/* pointer x, y coordinates in event window */
	jp_int x_root, y_root;	/* coordinates relative to root */
	jp_int state;	/* key or button mask */
	jp_int keycode;	/* detail */
	jp_int same_screen;	/* same screen flag */
} JPKeyEvent;
typedef JPKeyEvent JPKeyPressedEvent;
typedef JPKeyEvent JPKeyReleasedEvent;

typedef struct {
	jp_int type;		/* of event */
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;	        /* "event" window it is reported relative to */
	jp_long root;	        /* root window that the event occured on */
	jp_long subwindow;	/* child window */
	jp_long time;		/* milliseconds */
	jp_int x, y;		/* pointer x, y coordinates in event window */
	jp_int x_root, y_root;	/* coordinates relative to root */
	jp_int state;		/* key or button mask */
	jp_int button;		/* detail */
	jp_int same_screen;	/* same screen flag */
} JPButtonEvent;
typedef JPButtonEvent JPButtonPressedEvent;
typedef JPButtonEvent JPButtonReleasedEvent;

typedef struct {
	jp_int type;		/* of event */
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;	        /* "event" window reported relative to */
	jp_long root;	        /* root window that the event occured on */
	jp_long subwindow;	/* child window */
	jp_long time;		/* milliseconds */
	jp_int x, y;		/* pointer x, y coordinates in event window */
	jp_int x_root, y_root;	/* coordinates relative to root */
	jp_int state;		/* key or button mask */
	char is_hint;		/* detail */
	jp_int same_screen;	/* same screen flag */
} JPMotionEvent;
typedef JPMotionEvent JPPointerMovedEvent;

typedef struct {
	jp_int type;		/* of event */
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;	        /* "event" window reported relative to */
	jp_long root;	        /* root window that the event occured on */
	jp_long subwindow;	/* child window */
	jp_long time;		/* milliseconds */
	jp_int x, y;		/* pointer x, y coordinates in event window */
	jp_int x_root, y_root;	/* coordinates relative to root */
	jp_int mode;		/* NotifyNormal, NotifyGrab, NotifyUngrab */
	jp_int detail;
	/*
	 * NotifyAncestor, NotifyVirtual, NotifyInferior, 
	 * NotifyNonLinear,NotifyNonLinearVirtual
	 */
	jp_int same_screen;	/* same screen flag */
	jp_int focus;		/* boolean focus */
	jp_int state;		/* key or button mask */
} JPCrossingEvent;
typedef JPCrossingEvent JPEnterWindowEvent;
typedef JPCrossingEvent JPLeaveWindowEvent;

typedef struct {
	jp_int type;		/* FocusIn or FocusOut */
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;		/* window of event */
	jp_int mode;		/* NotifyNormal, NotifyGrab, NotifyUngrab */
	jp_int detail;
	/*
	 * NotifyAncestor, NotifyVirtual, NotifyInferior, 
	 * NotifyNonLinear,NotifyNonLinearVirtual, NotifyPointer,
	 * NotifyPointerRoot, NotifyDetailNone 
	 */
} JPFocusChangeEvent;
typedef JPFocusChangeEvent JPFocusInEvent;
typedef JPFocusChangeEvent JPFocusOutEvent;

/* generated on EnterWindow and FocusIn  when KeyMapState selected */
typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;
	char key_vector[32];
} JPKeymapEvent;	

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;
	jp_int x, y;
	jp_int width, height;
	jp_int count;		/* if non-zero, at least this many more */
} JPExposeEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long drawable;
	jp_int x, y;
	jp_int width, height;
	jp_int count;		/* if non-zero, at least this many more */
	jp_int major_code;	/* core is CopyArea or CopyPlane */
	jp_int minor_code;	/* not defined in the core */
} JPGraphicsExposeEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long drawable;
	jp_int major_code;	/* core is CopyArea or CopyPlane */
	jp_int minor_code;	/* not defined in the core */
} JPNoExposeEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;
	jp_int state;		/* Visibility state */
} JPVisibilityEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long parent;		/* parent of the window */
	jp_long window;		/* window id of window created */
	jp_int x, y;		/* window location */
	jp_int width, height;	/* size of window */
	jp_int border_width;	/* border width */
	jp_int override_redirect;	/* creation should be overridden */
} JPCreateWindowEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long event;
	jp_long window;
} JPDestroyWindowEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long event;
	jp_long window;
	jp_int from_configure;
} JPUnmapEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long event;
	jp_long window;
	jp_int override_redirect;	/* boolean, is override set... */
} JPMapEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long parent;
	jp_long window;
} JPMapRequestEvent;

typedef struct {
	jp_int type;
	jp_long serial;	/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long event;
	jp_long window;
	jp_long parent;
	jp_int x, y;
	jp_int override_redirect;
} JPReparentEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long event;
	jp_long window;
	jp_int x, y;
	jp_int width, height;
	jp_int border_width;
	jp_long above;
	jp_int override_redirect;
} JPConfigureEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long event;
	jp_long window;
	jp_int x, y;
} JPGravityEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;
	jp_int width, height;
} JPResizeRequestEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long parent;
	jp_long window;
	jp_int x, y;
	jp_int width, height;
	jp_int border_width;
	jp_long above;
	jp_int detail;		/* Above, Below, TopIf, BottomIf, Opposite */
	jp_long value_mask;
} JPConfigureRequestEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long event;
	jp_long window;
	jp_int place;		/* PlaceOnTop, PlaceOnBottom */
} JPCirculateEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long parent;
	jp_long window;
	jp_int place;		/* PlaceOnTop, PlaceOnBottom */
} JPCirculateRequestEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;
	jp_long atom;
	jp_long time;
	jp_int state;		/* NewValue, Deleted */
} JPPropertyEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;
	jp_long selection;
	jp_long time;
} JPSelectionClearEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long owner;
	jp_long requestor;
	jp_long selection;
	jp_long target;
	jp_long property;
	jp_long time;
} JPSelectionRequestEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long requestor;
	jp_long selection;
	jp_long target;
	jp_long property;		/* ATOM or None */
	jp_long time;
} JPSelectionEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;
	Colormap colormap;	/* COLORMAP or None */
#if defined(__cplusplus) || defined(c_plusplus)
	jp_int c_new;		/* C++ */
#else
	jp_int new;
#endif
	jp_int state;		/* ColormapInstalled, ColormapUninstalled */
} JPColormapEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;
	jp_long message_type;
	jp_int format;
	union {
		char b[20];
		jp_short s[10];
		jp_long l[5];
		} data;
} JPClientMessageEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;		/* unused */
	jp_int request;		/* one of MappingModifier, MappingKeyboard,
				   MappingPointer */
	jp_int first_keycode;	/* first keycode */
	jp_int count;		/* defines range of change w. first_keycode*/
} JPMappingEvent;

typedef struct {
	jp_int type;
	jp_addr display;	/* Display the event was read from */
	jp_long resourceid;	/* resource id */
	jp_long serial;		/* serial number of failed request */
	unsigned char error_code;	/* error code of failed request */
	unsigned char request_code;	/* Major op-code of failed request */
	unsigned char minor_code;	/* Minor op-code of failed request */
} JPErrorEvent;

typedef struct {
	jp_int type;
	jp_long serial;		/* # of last request processed by server */
	jp_int send_event;	/* true if this came from a SendEvent request */
	jp_addr display;	/* Display the event was read from */
	jp_long window;	/* window on which event was requested in event mask */
} JPAnyEvent;

/*
 * this union is defined so Xlib can always use the same sized
 * event structure internally, to avoid memory fragmentation.
 */
typedef union _JPEvent {
        jp_int type;		/* must not be changed; first element */
	JPAnyEvent xany;
	JPKeyEvent xkey;
	JPButtonEvent xbutton;
	JPMotionEvent xmotion;
	JPCrossingEvent xcrossing;
	JPFocusChangeEvent xfocus;
	JPExposeEvent xexpose;
	JPGraphicsExposeEvent xgraphicsexpose;
	JPNoExposeEvent xnoexpose;
	JPVisibilityEvent xvisibility;
	JPCreateWindowEvent xcreatewindow;
	JPDestroyWindowEvent xdestroywindow;
	JPUnmapEvent xunmap;
	JPMapEvent xmap;
	JPMapRequestEvent xmaprequest;
	JPReparentEvent xreparent;
	JPConfigureEvent xconfigure;
	JPGravityEvent xgravity;
	JPResizeRequestEvent xresizerequest;
	JPConfigureRequestEvent xconfigurerequest;
	JPCirculateEvent xcirculate;
	JPCirculateRequestEvent xcirculaterequest;
	JPPropertyEvent xproperty;
	JPSelectionClearEvent xselectionclear;
	JPSelectionRequestEvent xselectionrequest;
	JPSelectionEvent xselection;
	JPColormapEvent xcolormap;
	JPClientMessageEvent xclient;
	JPMappingEvent xmapping;
	JPErrorEvent xerror;
	JPKeymapEvent xkeymap;
	jp_long pad[24];
} JPEvent;

#endif /* _JPEvent_h_ */
