 /*
  * Khoros: $Id: vextract.h,v 1.2 1991/12/18 09:36:28 dkhoros Exp $
  */

 /*
  * $Log: vextract.h,v $
 * Revision 1.2  1991/12/18  09:36:28  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vextract.h
 >>>>            Author: John Rasure, Mark Young
 >>>> Date Last Updated: Thu Nov  7 11:59:20 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vextract_h_
#define _vextract_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vextract Argument Structure
*
****************************************************************/

typedef struct _vextract  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  input coordinate image (Optional infile)
 */
char	*i1_file;	/* input coordinate image FILENAME */
int	 i1_flag;	/* input coordinate image FLAG */

/*
 *  specifies upper left x coordinate of subimage (Optional integer)
 */
int	 x_int; 	/* specifies upper left x coordinate of subimage INT */
int	 x_flag;	/* specifies upper left x coordinate of subimage FLAG */

/*
 *  specifies upper left y coordinate of subimage (Optional integer)
 */
int	 y_int; 	/* specifies upper left y coordinate of subimage INT */
int	 y_flag;	/* specifies upper left y coordinate of subimage FLAG */

/*
 *  specifies the subimage width in pixels (Optional integer)
 */
int	 w_int; 	/* specifies the subimage width in pixels INT */
int	 w_flag;	/* specifies the subimage width in pixels FLAG */

/*
 *  specifies the subimage height in pixels (Optional integer)
 */
int	 h_int; 	/* specifies the subimage height in pixels INT */
int	 h_flag;	/* specifies the subimage height in pixels FLAG */

}  vextract_struct;

vextract_struct *vextract;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, img1) \
      (void) proper_num_images(program,img1,1,TRUE);

#define CHECKCOORDINPUT(program,corrd_img ) \
      (void) proper_num_images(program,corrd_img,1,TRUE); \
      if ((propertype(program, corrd_img,VFF_TYP_BIT, FALSE)) || \
          (propertype(program, corrd_img,VFF_TYP_COMPLEX, FALSE))) \
      { \
         (void) fprintf(stderr, \
          "vextract: Error, Coordinate Image must be of data storage type:\n"); \
         (void) fprintf(stderr, "  Byte, Short, Int, Float or Double\n"); \
         exit(1); \
      } \
      if ( corrd_img->row_size < 2 ||  corrd_img->col_size < 3) \
      { \
         (void) fprintf(stderr, \
          "vextract: Error, Coordinate Image must contain at least 2 cols and 3 rows\n"); \
         exit(1); \
      }
/* -include_macros_end */

#endif
