 /*
  * Khoros: $Id: vcmtrans.c,v 1.1 1991/05/10 15:46:31 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vcmtrans.c,v 1.1 1991/05/10 15:46:31 khoros Exp $";
#endif

 /*
  * $Log: vcmtrans.c,v $
 * Revision 1.1  1991/05/10  15:46:31  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vcmtrans.c
 >>>>
 >>>>      Program Name: vcmtrans
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Linear color space conversions with a specified 3x3 matrix
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:21:57 1991
 >>>>
 >>>>          Routines: main- the main program for vcmtrans
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vcmtrans.h"


/****************************************************************
 *
 * Routine Name:  main program for vcmtrans
 *
 *       Input:  
 *          -i1  input image 
 *          -i2  input conversion image 
 *          -o  output resulting image 
 *
 *
 *          [-n] specifies normalization factor (default = 255)  (value > 0.0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *image1, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

READINPUT (image);
READINPUT1 (image1);
CHECKINPUT (program, image);
CHECKMATRIXINPUT (program, image1);
/* -main_before_lib_call_end */

/* -main_library_call */
if(! lvcltrans(image, 0, 0, vcmtrans->n_float, vcmtrans->n_flag, TRUE, image1))
 {
    (void) fprintf(stderr, "lvcltrans Failed\\n");
    exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vcmtrans->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vcmtrans 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vcmtrans :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tLinear color space conversions with a specified 3x3 matrix\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input image  (infile)\n");
	fprintf(stderr,"\t-i2  input conversion image  (infile)\n");
	fprintf(stderr,"\t-o  output resulting image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-n]  specifies normalization factor (default = 255) (float, > 0.0) [255]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vcmtrans\n");
	fprintf(stderr, "\t[-U] Gives the usage for vcmtrans\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vcmtrans.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vcmtrans.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vcmtrans
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input conversion image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output resulting image \n        {outfile}: "; 
char	*n_pstr = 
	"\nEnter: (n) specifies normalization factor (default = 255) \n        {float, > 0.0 [255.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vcmtrans", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vcmtrans.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vcmtrans: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vcmtrans.ans");
		}

	     }

	}

	/*
	 * allocate the vcmtrans structure
	 */
	vcmtrans = (vcmtrans_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vcmtrans_struct));

	/*
	 * get required arguments for vcmtrans
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vcmtrans->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vcmtrans->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcmtrans->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vcmtrans->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vcmtrans->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vcmtrans->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vcmtrans->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcmtrans->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vcmtrans->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vcmtrans->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vcmtrans->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vcmtrans->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcmtrans->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vcmtrans->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vcmtrans->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vcmtrans
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vcmtrans->n_flag = vget_float(fid, prompt_flag,
	"-n", n_pstr, &(vcmtrans->n_float),
	255.000000, 2.000000, 2.000000);


}



