 /*
  * Khoros: $Id: lmeigen.c,v 1.5 1992/03/25 17:31:40 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lmeigen.c,v 1.5 1992/03/25 17:31:40 dkhoros Exp $";
#endif

 /*
  * $Log: lmeigen.c,v $
 * Revision 1.5  1992/03/25  17:31:40  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lmeigen.c
 >>>>
 >>>>      Program Name: meigen
 >>>>
 >>>> Date Last Updated: Thu Mar  5 08:57:32 1992 
 >>>>
 >>>>          Routines: lmeigen - the library call for meigen
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#define CLEANUP \
    {  /* cleanup workspace before leaving */ \
       if(matr!=NULL)free(matr); \
       if(mati!=NULL)free(mati); \
       if(fv1!=NULL)free(fv1); \
       if(fv2!=NULL)free(fv2); \
       if(fv3!=NULL)free(fv3); \
       if(eigvctr!=NULL)free(eigvctr); \
       if(eigvcti!=NULL)free(eigvcti); \
       if(eigvalr!=NULL)free(eigvalr); \
       if(eigvali!=NULL)free(eigvali); \
    } /* end of cleanup code */

static int leigen();
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lmeigen - library call for meigen
*
* Purpose:
*    
*    computes  the  eigenvalues  and  eigenvectors  of  a  square
*    matrix.
*    
*    

* Input:
*    
*    image          pointer to VIFF structure containing image data to
*                   be processed.
*    
*    out_option     specifies what output  is  desired.   if  zero  is
*                   selected, no output is desired.  if 1 is selected,
*                   then the eigenvalues only are desired. 2  is  used
*                   for eigenvectors only.  3 for both eigenvalues and
*                   eigenvectors.
*    
*    arith_type     type of arithmetic to be used on complex data.   0
*                   specifies scalar arithmetic and 1 specifies vector
*                   arithmetic.
*    
*    

* Output:
*    
*    image          pointer to viff structure containing an  array  of
*                   eigenvectors.
*    
*    values         pointer to viff structure containing a  triangular
*                   matrix of eigenvalues.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    

*
* Written By: Jeremy Worley
*    
*    Jeremy Worley 09 Aug 1991 10:36 MDT
*              Changed real case so that it generates complex  results
*              at all times.
*    
*    Jeremy Worley 27 Jan 1992 09:54 MST
*              Changed declaration of leigen() in lmeigen() to  static
*              int.
*    
*    Jeremy Worley 05 Mar 1992 08:44 MST
*              Moved  the  static  declaration  of  leigen  into   the
*              includes section.
*    
*    

****************************************************************/


/* -library_def */
int lmeigen(image,vimage,out_option,arith_type)
  struct xvimage *vimage, *image;
  int arith_type,out_option;
/* -library_def_end */

/* -library_code */
{
  int i,vidx,rows,cols,bands,type;
  double *kern,*values,*vectors;
  int proper_num_images(), lvcast();

  char *program = "lmeigen";

  bands = (int)image->num_data_bands;
  rows = (int)image->col_size;
  cols = (int)image->row_size;

  if(rows!=cols){
     fprintf(stderr,"%s:  matrices must be square.\n",program);
     return(0);
  }

  if(!proper_num_images(program,image,1,FALSE)){
     fprintf(stderr,"%s:  image structures should contain only one image.\n",
           program);
     return(0);
  }

/*
** cast all of the data up to double or double complex
*/

   if(image->data_storage_type==VFF_TYP_COMPLEX || image->data_storage_type==
        VFF_TYP_DCOMPLEX){
      if(!lvcast(&image,(int)1,(int)VFF_TYP_DCOMPLEX)){
         fprintf(stderr,"%s:  Failure to cast up to double complex.\n",program);
         return(0);
      }
      type = 1;
   }else{
      if(!lvcast(&image,(int)1,(int)VFF_TYP_DOUBLE)){
         fprintf(stderr,"%s:  Failure to cast up to double.\n",program);
         return(0);
      }
      type = 0;
   }

  if((vectors = (double *)malloc(bands*rows*cols*2*sizeof(double)))
       ==NULL){
     (void)fprintf(stderr,"%s:  unable to allocate s matrix.\n",program);
     return(0);
  }

  if((values = (double *)malloc(bands*rows*cols*2*sizeof(double)))
       ==NULL){
     (void)fprintf(stderr,"%s:  unable to allocate s matrix.\n",program);
     return(0);
  }

/*
** process all of the data
*/

   kern = (double *)(image->imagedata);
   for(i=0;i<bands;i++){
      vidx = (type+1)*rows*cols*i;
      if(!leigen(&(vectors[vidx]),&(values[vidx]),kern,rows,type,out_option,
         arith_type)){
         fprintf(stderr,"%s:  Failed call to static routine.\n",program);
         return(0);
      }
      kern += (type+1)*rows*cols;
   }

/*
** free up our junk and get the heck outa here.
*/

   image->data_storage_type = VFF_TYP_DCOMPLEX;
   vimage->data_storage_type = image->data_storage_type;
   vimage->row_size = cols;
   vimage->col_size = rows;
   vimage->num_data_bands = bands;

   image->imagedata = (char *)vectors;
   vimage->imagedata = (char *)values;

   return(1);
}

/***********************************************************************
*
*  Routine Name: leigen()
*
*          Date:
*        
*       Purpose:  
*
*         Input: 
*
*        Output: 
*
*    Written By: Jeremy Worley 
*
* Modifications:
*
***********************************************************************/

static int leigen(vectors,values,matrix,order,type,out_option,arith_type)
  double *vectors, *values, *matrix;
  int order,out_option,arith_type,type;
{
  int   index1,index2,k,j;
  void cg_();
  void swap();

  double *eigvalr=NULL, *eigvali=NULL, *eigvctr=NULL, *eigvcti=NULL, 
         *matr=NULL, *mati=NULL, *fv1, *fv2=NULL, *fv3=NULL;
  int opt, ierr;
  char *program = "lmeigen";

/*
** allocate work arrays
*/

  fv1 = (double *)malloc((unsigned)order * sizeof(double));
  if(fv1==NULL){
     fprintf(stderr,"%s:  [4]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

  fv2 = (double *)malloc((unsigned)order * sizeof(double));
  if(fv2==NULL){
     fprintf(stderr,"%s:  [5]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

  fv3 = (double *)malloc((unsigned)order * sizeof(double));
  if(fv3==NULL){
     fprintf(stderr,"%s:  [5]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

/*
** allocate memory for real and imaginary matrix
*/

  matr = (double *)malloc((unsigned)order * order * sizeof(double));
  if(matr==NULL){
     fprintf(stderr,"%s:  [11]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }
 
  mati = (double *)malloc((unsigned)order * order * sizeof(double));
  if(mati==NULL){
     fprintf(stderr,"%s:  [11]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

/*
** allocate memory for output of vectors and values 
*/

  eigvctr = (double *)malloc((unsigned)order * order * sizeof(double));
  if(eigvctr==NULL){
     fprintf(stderr,"%s:  [11]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

  eigvcti = (double *)malloc((unsigned)order * order * sizeof(double));
  if(eigvcti==NULL){
     fprintf(stderr,"%s:  [11]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

  eigvalr = (double *)malloc((unsigned)order * sizeof(double));
  if(eigvalr==NULL){
     fprintf(stderr,"%s:  [5]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

  eigvali = (double *)malloc((unsigned)order * sizeof(double));
  if(eigvali==NULL){
     fprintf(stderr,"%s:  [5]memory allocation failure.\n",program);
     CLEANUP;
     return(0);
  }

/*
** if only the eigenvalues are wanted, then we only generate the eigenvalues.
*/

  opt = 1;
  if(out_option==2)opt = 0;

/*
** first case: real data
*/

      if(type==0){
         for(j=0;j<order;j++){
             for(k=0;k<order;k++){
                matr[j*order+k] = matrix[j+k*order];
                mati[j*order+k] = 0.0;
             }
         }
         (void)cg_(&order,&order,matr,mati,eigvalr,eigvali,&opt,eigvctr,eigvcti,
                   fv1,fv2,fv3,&ierr);
         if(ierr!=0){
            fprintf(stderr,"%s:  Eispack routine cg was unable e-values\n",
                        program);
            CLEANUP;
            return(0);
         }

         for(j=0;j<order;j++){
             if((out_option & 1) != 0){
                for(k=0;k<order;k++){
                    index1 = k + j*order;
                    index2 = k*order + j;
                    vectors[2*index1] = eigvctr[index2];
                    vectors[2*index1+1] = eigvcti[index2];
                }
             }
             if((out_option & 2) != 0)
                 values[(j*order + j)*2] = eigvalr[j];
                 values[(j*order + j)*2 + 1] = eigvali[j];
         }

/*
** first complex case:  vector arithmetic
*/

      }else if(arith_type == 1){

         for(j=0;j<order;j++){
             for(k=0;k<order;k++){
                index1 = j*order + k;
                index2 = j + k*order ;
                matr[index1] = matrix[2*index2];
                mati[index1] = matrix[2*index2 + 1];
             }
         }
         (void)cg_(&order,&order,matr,mati,eigvalr,eigvali,&opt,eigvctr,eigvcti,
                   fv1,fv2,fv3,&ierr);
         if(ierr!=0){
            fprintf(stderr,"%s:  Eispack routine cg was unable e-values\n",
                        program);
            CLEANUP;
            return(0);
         }

         for(j=0;j<order;j++){
             if((out_option & 1) != 0){
                for(k=0;k<order;k++){
                    index1 = k + j*order;
                    index2 = k*order + j;
                    vectors[2*index1] = eigvctr[index2];
                    vectors[2*index1+1] = eigvcti[index2];
                }
             }
             if((out_option & 2) != 0){
                 values[(j*order + j)*2] = eigvalr[j];
                 values[(j*order + j)*2 + 1] = eigvali[j];
             }
         }

/*
** second complex case:  scalar arithmetic
*/


      }else{

/*
** real part of scalar arithmetic option
*/

         for(j=0;j<order;j++){
             for(k=0;k<order;k++){
                index1 = j*order + k;
                index2 = j + k*order ;
                matr[index1] = matrix[2*index2];
                mati[index1] = 0.0;
             }
         }
         (void)cg_(&order,&order,matr,mati,eigvalr,eigvali,&opt,eigvctr,eigvcti,
                   fv1,fv2,fv3,&ierr);
         if(ierr!=0){
            fprintf(stderr,"%s:  cg was to compute unable e-values\n",
                        program);
            CLEANUP;
            return(0);
         }

         for(j=0;j<order;j++){
             if((out_option & 1) != 0){
                for(k=0;k<order;k++){
                    index1 = k + j*order ;
                    index2 = k*order + j;
                    vectors[2*index1] = eigvctr[index2];
                }
             }
             if((out_option & 2) != 0){
                 values[(j*order + j)*2] = eigvalr[j];
             }
         }

/*
** imaginary part of scalar arithmetic option
*/

         for(j=0;j<order;j++){
             for(k=0;k<order;k++){
                index1 = j*order + k;
                index2 = j + k*order ;
                matr[index1] = matrix[2*index2+1];
                mati[index1] = 0.0;
             }
         }
         (void)cg_(&order,&order,matr,mati,eigvalr,eigvali,&opt,eigvctr,eigvcti,
                   fv1,fv2,fv3,&ierr);
         if(ierr!=0){
            fprintf(stderr,"%s:  Eispack routine cg was unable e-values\n",
                        program);
            CLEANUP;
            return(0);
         }

         for(j=0;j<order;j++){
             if((out_option & 1) != 0){
                for(k=0;k<order;k++){
                    /* index1 = k + j*order ; */
                    index2 = k*order + j;
                    vectors[2*index2] = eigvctr[index2];
                }
             }
             if((out_option & 2) != 0){
                 values[(j*order + j)*2 + 1] = eigvalr[j];

             }
         }

      } /* end big if statement */

    return(1);
}
/* -library_code_end */
