#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/hidd.c,v 1.2 89/08/17 15:17:43 jeffw Exp $";
#endif /* not lint */

/*
 * hidd.c
 *
 * do a hidden values report
 *
 * Jeff Wallace, 1989
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "file.h"


hidd()
{
	extern	char *argp[];
	struct	sctstr sect;
	int	nsect;
	struct	nstr_sect nstr;
	int	cond[I_MAX+1];

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	prdate();
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (nsect++ == 0) {
			if (god)
				pr("    ");
			pr("HIDDEN VALUES     old        che-------  plague----\n");
			if (god)
				pr("own ");
			pr("  sect        eff own  loyal cnum value  stage time mines\n");
		}
		if (god)
			pr(fmt("%3d ", sect.sct_own));
		getvec(VT_COND, cond, (char *)&sect, EF_SECTOR);
		pr(xyfmt("%4d,%-4d", nstr.x, nstr.y, cnum));
		pr(fmt(" %c  %3d%% %3d   %3d  %3d  %3d    %3d   %3d  %3d",
			dchr[sect.sct_type].d_mnem, sect.sct_effic,
			sect.sct_oldown, sect.sct_loyal,
			get_che_cnum(cond[C_CHE]),
			get_che_value(cond[C_CHE]),
			cond[C_PSTAGE], cond[C_PTIME],
			cond[C_MINE]));
		pr("\n");
	}
	pr(fmt("    %d sector%s\n", nsect, splur(nsect)));
	return 0;
}
