#ifndef lint
static char *RCSid = "$Header: bomb.c,v 1.12 89/12/04 20:39:41 mr-frog Exp $";
#endif

/*
 * pinp.c
 *
 * Pinpoint bombing mission
 *
 * Dave Pare, 1986
 */

#include <ctype.h>
#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "item.h"
#include "plane.h"
#include "nuke.h"
#include "xy.h"
#include "nsc.h"
#include "news.h"
#include "file.h"
#include "nat.h"
#include "path.h"

static	pin_bomb();
static	nuke_bomb();
static	strat_bomb();

static	comm_bomb();
static	plane_bomb();
static	ship_bomb();
static	eff_bomb();

bomb()
{
	extern	char *argp[];
	char	*p;
	int	mission_flags;
	coord	tx, ty;
	coord	ax, ay;
	int	ap_to_target;
	struct	ichrstr *ip;
	char	flightpath[256];
	struct	nstr_item ni_bomb;
	struct	nstr_item ni_esc;
	coord	x, y;
	struct	sctstr target;
	struct	qelem bomb_list;
	struct	qelem esc_list;
	int	wantflags;
	struct	sctstr ap_sect;
	char	mission;

	wantflags = 0;
	if (!snxtitem(&ni_bomb, EF_PLANE, argp[1]))
		return RET_SYN;
	if (!snxtitem(&ni_esc, EF_PLANE, argp[2]))
		pr("No escorts...\n");
	if ((p = getstarg(argp[3], "pinpoint, strategic, or nuclear? ")) == 0)
		return RET_SYN;
	mission = *p;
	if (index("psn", mission) == 0)
		return RET_SYN;
	if ((p = getstarg(argp[4], "assembly point? ")) == 0 || *p == 0)
		return RET_SYN;
	if (!sarg_xy(p, &x, &y) || !getsect(x, y, &ap_sect))
		return RET_SYN;
	if (ap_sect.sct_own && ap_sect.sct_own != cnum) {
		pr("Assembly point not owned by you!\n");
		return RET_SYN;
	}
	ax = x;
	ay = y;
	if ((p = getpath(argp[5], ax, ay, 0, 0, 0)) == 0 || *p == 0)
		return RET_SYN;
	(void)strcpy(flightpath, p);
	tx = ax;
	ty = ay;
	(void) pathtoxy(flightpath, &tx, &ty, fcost);
	pr(fmt("target sector is %s\n", xyas(tx, ty, cnum)));
	getsect(tx, ty, &target);
	if (target.sct_type == SCT_SANCT) {
		pr("You can't bomb that sector!\n");
		return RET_SYN;
	}
	ip = 0;
	ap_to_target = strlen(flightpath);
	pr(fmt("range to target is %d\n", ap_to_target));
	/*
	 * select planes within range
	 */
	pln_sel(&ni_bomb, &bomb_list, &ap_sect, ap_to_target,
		2, wantflags, P_M|P_O);
	pln_sel(&ni_esc, &esc_list, &ap_sect, ap_to_target,
		2, P_F, P_M|P_O);
	/*
	 * now arm and equip the bombers, transports, whatever.
	 * tech is stored in high 16 bits of mission_flags.
	 * yuck.
	 */
	mission_flags = 0x7fff0000;
	mission_flags |= P_X;		/* stealth (shhh) */
	mission_flags = pln_arm(&bomb_list, mission, ip, 0, mission_flags);
	if (QEMPTY(&bomb_list)) {
		pr("No planes could be equipped for the mission.\n");
		return RET_FAIL;
	}
	mission_flags = pln_arm(&esc_list, mission, ip, P_F, mission_flags);
	ac_encounter(&bomb_list, &esc_list, ax, ay, flightpath, mission_flags);
	if (QEMPTY(&bomb_list)) {
		pr(fmt("No planes got through fighter defenses\n"));
	} else {
		getsect(tx, ty, &target);
		switch (mission) {
		case 'p':
			pin_bomb(&bomb_list, &target);
			putsect(&target);
			break;
		case 'n':
			nuke_bomb(&bomb_list, &target);
			break;
		case 's':
			nreport(cnum, N_SCT_BOMB, target.sct_own, 1);
			strat_bomb(&bomb_list, &target);
			putsect(&target);
			break;
		default:
			pr(fmt("Bad mission %c\n", mission));
			break;
		}
		pln_return(&bomb_list);
		pln_return(&esc_list);
	}
	pln_put(&bomb_list);
	pln_put(&esc_list);
	return RET_OK;
}

static
pin_bomb(list, target)
	struct	qelem *list;
	struct	sctstr *target;
{
	extern	char *effadv();
	extern	int aborted;
	struct	dchrstr *dcp;
	int	nplanes;
	int	nships;
	int	type;
	int	bad;
	char	*p;
	int	vec[I_MAX+1];

	bad = 0;
	type = target->sct_type;
	dcp = &dchr[type];
	pr(fmt("Target sector is a %s constructed %s\n", 
		effadv((int)target->sct_effic), dcp->d_name));
	nships = shipsatxy(target->sct_x, target->sct_y, 0, M_SUB);
	nplanes = planesatxy(target->sct_x, target->sct_y, 0, 0);
	getvec(VT_ITEM, vec, (char *)target, EF_SECTOR);
retry:
	p = getstring("Bomb what? (ship, plane, efficiency, commodities) ");
	if (p == 0 || *p == 0) {
		if (aborted)
			return;
		bad++;
		if (bad > 2)
			return;
		goto retry;
	}
	switch (*p) {
	case 'p':
		if (nplanes == 0) {
			pr("no planes there\n");
			goto retry;
		}
		plane_bomb(list, target);
		break;
	case 's':
		if (nships == 0) {
			pr("no ships there\n");
			goto retry;
		}
		ship_bomb(list, target);
		break;
	case 'c':
		if (!vec[I_SHELL] && !vec[I_GUN] && !vec[I_MILIT] &&
		    !vec[I_PETROL] && !vec[I_OIL] && !vec[I_RAD]) {
			pr(fmt("No bombable commodities in %s\n",
				xyas(target->sct_x, target->sct_y, cnum)));
			goto retry;
		}
		comm_bomb(list, target);
		break;
	case 'e':
		eff_bomb(list, target);
		break;
	case 'q':
		pr("Aborting mission.\n");
		return;
	default:
		pr("Bad target type.\n");
		goto retry;
	}
}

static
eff_bomb(list, target)
	struct	qelem *list;
	struct	sctstr *target;
{
	register struct plist *plp;
	float	eff;
	int	bombs;
	struct	qelem *qp;
	int	i;

	eff = 1.0;
	for (qp = list->q_forw; qp != list; qp = qp->q_forw) {
		plp = (struct plist *) qp;
		if (plp->pcp->pl_flags & P_C)
			continue;
		bombs = plp->bombs;
		for (i=0; i<bombs; i++) {
			if (i)
				pr("-");
			if (roll(100) > plp->pcp->pl_acc) {
				eff *= 0.88;
				pr("HIT");
			} else
				pr("miss");
		}
		pr("\n");
	}
	target->sct_effic = (target->sct_effic * eff);
	pr(fmt("did %.2f%% damage to efficiency in %s\n",
		100.0 - (eff*100), xyas(target->sct_x, target->sct_y, cnum)));
#ifdef MERC
	if(target->sct_own != 0)
#endif
	wu(0, target->sct_own, 
		fmt("%s bombing raid did %.2f%% damage in %s",
		cname(cnum), 100.0 - (eff*100),
		xyas(target->sct_x, target->sct_y, target->sct_own)));
}

#ifdef MERC
static int bombcomm[] = {
	I_CIVIL,
	I_MILIT,
	I_SHELL,
	I_GUN,
	I_PETROL,
	I_IRON,
	I_DUST,
	I_BAR,
	I_FOOD,
	I_OIL,
	I_LCM,
	I_HCM,
	I_UW,
	I_RAD
};
#else
static int bombcomm[] = { I_SHELL, I_GUN, I_MILIT, I_PETROL, I_OIL, I_RAD };
#endif
static int nbomb = sizeof(bombcomm) / sizeof(int);

static
comm_bomb(list, target)
	struct	qelem *list;
	struct	sctstr *target;
{
	register struct plist *plp;
	float	eff;
	int	bombs;
	int	i;
	int	amt;
	int	blownup;
	struct	ichrstr *ip;
	float	coll;
	int	vec[I_MAX+1];
	struct	qelem *qp;

	getvec(VT_ITEM, vec, (char *)target, EF_SECTOR);
	for (i=0; i<nbomb; i++) {
		if (vec[bombcomm[i]] == 0)
			continue;
		ip = &ichr[bombcomm[i]];
		pr(fmt("some %s\n", ip->i_name));
	}
#ifdef MERC
	for(;;) {
		if((ip = whatitem((char *) 0, "commodity to bomb? ")) == 0)
			continue;

		for (i=0; i<nbomb; i++) {
			if (&ichr[bombcomm[i]] == ip)
				break;
		}
		if (i == nbomb) {
			pr(fmt("You can't bomb %s!\n", ip->i_name));
			for (i=0; i<nbomb; i++) {
				pr(i == 0 ? "Bombable: " : ", ");
				pr(ichr[bombcomm[i]].i_name);
			}
			pr("\n");
		} else
			break;
	}
#else
	while ((ip = whatitem((char *)0, "commodity to bomb? ")) == 0) {
		for (i=0; i<nbomb; i++) {
			if (&ichr[bombcomm[i]] == ip)
				break;
		}
		if (i == nbomb) {
			pr(fmt("You can't bomb %s!\n", ip->i_name));
			for (i=0; i<nbomb; i++) {
				pr(i == 0 ? "Bombable: " : ", ");
				pr(ichr[bombcomm[i]].i_name);
			}
			pr("\n");
		} else
			break;
	}
#endif
	eff = 100.0;
	coll = 100.0;
	for (qp = list->q_forw; qp != list; qp = qp->q_forw) {
		plp = (struct plist *) qp;
		if (plp->pcp->pl_flags & P_C)
			continue;
		bombs = plp->bombs;
		for (i=0; i<bombs; i++) {
			if (i)
				pr("-");
			if (roll(100) > plp->pcp->pl_acc) {
				eff *= (100 - (roll(8) + 8)) / 100.0;
				pr("BLAM");
				coll *= 0.99;
			} else {
				coll *= 0.98;
				pr("boom");
			}
		}
		pr("\n");
	}
	amt = getvar(ip->i_vtype, (char *)target, EF_SECTOR);
	blownup = amt - (amt * eff / 100.0);
	putvar(ip->i_vtype, amt - blownup, (char *)target, EF_SECTOR);
	sectdamage(target, (int) (100.0 - coll));
	pr(fmt("did %.2f%% damage to %s level and %.2f%% damage to %s\n",
		100.0 - eff, ip->i_name, 100.0 - coll,
		xyas(target->sct_x, target->sct_y, cnum)));
	nreport(cnum, N_SCT_BOMB, target->sct_own, 1);
#ifdef MERC
	if(target->sct_own != 0)
#endif
	wu(0, target->sct_own,
		fmt("%s precision bombing raid did %.2f%% damage to %s in %s",
		cname(cnum), 100.0 - eff, ip->i_name,
		xyas(target->sct_x, target->sct_y, target->sct_own)));
}

static
ship_bomb(list, target)
	struct	qelem *list;
	struct	sctstr *target;
{
	extern	int aborted;
	struct	plist *plp;
	int	bombs;
	int	onsea;
	struct	mchrstr *mcp;
	int	acc;
	int	vis;
	int	dam;
	char	*q;
	int	i;
	int	n;
	char	buf[80];
	struct	qelem *qp;
	int	shipno;
	struct	shpstr ship;

	onsea = (target->sct_type == SCT_WATER) ? 1 : 0;
	for (qp = list->q_forw; qp != list && !aborted; qp = qp->q_forw) {
		plp = (struct plist *) qp;
		if (plp->pcp->pl_flags & P_C)
			continue;
		bombs = plp->bombs;
		(void) sprintf(buf, "%s (#%d), %d bombs.  Target? ",
			plp->pcp->pl_name, plp->plane.pln_uid, bombs);
		shipno = -1;
		while (shipno < 0 && !aborted) {
			if ((q = getstring(buf)) == 0 || *q == 0)
				continue;
			if (*q == '?') {
				shipsatxy(target->sct_x, target->sct_y,
					0, M_SUB);
				continue;
			}
			if (*q == 'd')
				goto next;
			if (!isdigit(*q))
				continue;
			n = atoi(q);
			if (n < 0)
				continue;
			if (getship(n, &ship) && ship.shp_x == target->sct_x &&
			    ship.shp_y == target->sct_y)
				shipno = n;
		}
		if (shipno < 0)
			continue;
		mcp = &mchr[ship.shp_type];
		/*
		 * subs in port are sitting ducks, while subs
		 * at sea are impossible to spot.
		 */
		vis = mcp->m_visib;
		if (mcp->m_flags & M_SUB) {
			if (onsea)
				continue;
			vis = 20;
		}
		/*
		 * ships on high seas are harder to hit because they're
		 * moving around so much! (and practically impossible to
		 * hit for the poor strategic bombers)
		 */
		acc = plp->pcp->pl_acc - vis + (mcp->m_speed * onsea);
		if ((plp->pcp->pl_flags & P_T) == 0)
			acc += 35;
		dam = 0;
		if (roll(100) > acc) {
			i = roll(bombs) + 1;
			if (i > bombs)
				i = bombs;
			while (i--) {
				pr("BLAM");
				if (i)
					pr("-");
				dam += ((roll(8)+6) * 127) / mcp->m_armor;
			}
			pr("\n");
		} else {
			pr("splash\n");
		}
		nreport(cnum, N_SHP_BOMB, ship.shp_own, 1);
		if (dam > 100)
			dam = 100;
		shipdamage(&ship, dam);
#ifdef MERC
		if(ship.shp_own != 0)
#endif
#ifdef	SHIPNAMES
		wu(0, ship.shp_own, fmt("%s bombs did %d%% damage to %s %s(#%d) at %s",
			cname(cnum), dam, mcp->m_name, ship.shp_name,
			ship.shp_uid,
#else
		wu(0, ship.shp_own, fmt("%s bombs did %d%% damage to %s #%d at %s",
			cname(cnum), dam, mcp->m_name, ship.shp_uid,
#endif	SHIPNAMES
			xyas(target->sct_x, target->sct_y, ship.shp_own)));
		pr("\n");
		putship(n, &ship);
next:
		;
	}
}

static
plane_bomb(list, target)
	struct	qelem *list;
	struct	sctstr *target;
{
	extern int aborted;
	int	bombs;
	int	acc;
	int	dam;
	char	*q;
	int	i;
	int	n;
	natid	own;
	char	buf[80];
	struct	plnstr plane;
	struct	qelem *qp;
	int	planeno;
	struct	plist *plp;

	for (qp = list->q_forw; qp != list; qp = qp->q_forw) {
		plp = (struct plist *) qp;
		if (plp->pcp->pl_flags & P_C)
			continue;
		bombs = plp->bombs;
		(void) sprintf(buf, "%s (#%d), %d bombs.  Target? ",
			plp->pcp->pl_name, plp->plane.pln_uid, bombs);
		planeno = -1;
		while (planeno < 0 && !aborted) {
			if ((q = getstring(buf)) == 0 || *q == 0)
				continue;
			if (*q == '?') {
				planesatxy(target->sct_x, target->sct_y, 0, 0);
				continue;
			}
			if (*q == 'd')
				goto next;
			n = atoi(q);
			if (n < 0)
				continue;
			if (getplane(n, &plane) &&
			    plane.pln_x == target->sct_x &&
			    plane.pln_y == target->sct_y &&
			    (plane.pln_flags & PLN_LAUNCHED) == 0)
				planeno = n;
			else
				pr(fmt("Plane #%d not spotted\n", n));
		}
		if (planeno < 0)
			continue;
		dam = 0;
		acc = plp->pcp->pl_acc;
		if (roll(100) > acc) {
			i = roll(bombs) + 1;
			if (i > bombs)
				i = bombs;
			while (i--) {
				pr("BLAM");
				if (i)
					pr("-");
				dam += (roll(16)+12)*2;
			}
			pr("\n");
		} else {
			pr("thud\n");
		}
		if (dam <= 0)
			continue;
		if (dam > 100)
			dam = 100;
		own = plane.pln_own;
		if (dam > plane.pln_effic) {
			plane.pln_effic = 0;
			plane.pln_own = 0;
		} else
			plane.pln_effic -= dam;
		plane.pln_mobil = (dam * plane.pln_mobil / 100.0);
		if (own == cnum) {
			pr(fmt("%s %d reports %d%% damage\n",
				plchr[plane.pln_type].pl_name, n, dam));
		} else {
#ifdef MERC
			if(own != 0)
#endif
			wu(0, own,
			    fmt("%s pinpoint bombing raid did %d%% damage to %s #%d",
				cname(cnum), dam, plchr[plane.pln_type].pl_name,
				n));
		}
		nreport(cnum, N_DOWN_PLANE, plane.pln_own, 1);
#ifdef MERC
		if(own != 0)
#endif
		wu(0, own, fmt("%s bombs did %d%% damage to %s #%d at %s",
			cname(cnum), dam, plchr[plane.pln_type].pl_name, n,
			xyas(target->sct_x, target->sct_y, own)));
		putplane(n, &plane);
next:
		;
	}
}

static
nuke_bomb(list, target)
	struct	qelem *list;
	struct	sctstr *target;
{
	register struct plist *plp;
	struct	qelem *qp;

	for (qp = list->q_forw; qp != list; qp = qp->q_forw) {
		plp = (struct plist *) qp;
		if (plp->pcp->pl_flags & P_C)
			continue;
		if (plp->plane.pln_nukeamt == 0)
			continue;
		/*
		 * just drop one nuke per plane
		 * For now, only single-hex missions
		 * for nuclear fire missions
		 * its kinda silly to drop one nuke per plane,
		 * but...
		 * also, air bursts are only thing available
		 * from planes (to make them effectively
		 * second strike weapons)
		 */
		plp->plane.pln_nukeamt--;
		detonate(plp->plane.pln_nuketype, target->sct_x,
			target->sct_y, 1, cnum);
	}
}

static
strat_bomb(list, target)
	struct	qelem *list;
	struct	sctstr *target;
{
	register struct plist *plp;
	float	eff;
	float	damage;
	int	dam;
	int	bombs;
	int	n;
	struct	qelem *qp;
	int	i;
	int	acc;

	eff = 100.0;
	for (qp = list->q_forw; qp != list; qp = qp->q_forw) {
		plp = (struct plist *) qp;
		if (plp->pcp->pl_flags & P_C)
			continue;
		bombs = plp->bombs;
		acc = plp->pcp->pl_acc;
		if (plp->pcp->pl_flags & P_T) acc = 130 - acc;
		for (i=0; i<bombs; i++) {
			if (i)
				pr("-");
			n = roll(100);
			if (n <= 10) {
				damage = 0.92;	/* 8% */
				pr("BLAM");
			} else if (n > acc - 30) {
				damage = 0.95;	/* 5% */
				pr("Blam");
			} else {
				damage = 0.98;	/* 2% */
				pr("blam");
			}
			eff *= damage;
		}
		pr("\n");
	}
	dam = (int) (100.0 - eff);
	pr(fmt("did %d%% damage in %s\n", dam,
		xyas(target->sct_x, target->sct_y, cnum)));
#ifdef MERC
	if(target->sct_own != 0)
#endif
	wu(0, target->sct_own, fmt("%s bombing raid did %d%% damage in %s",
		cname(cnum), dam,
		xyas(target->sct_x, target->sct_y, target->sct_own)));
	sectdamage(target, dam);
}
