#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/SUBS/RCS/getbit.c,v 1.2 89/05/28 16:27:56 emp-src Exp $";
#endif

/*
 * getbit.c
 *
 * replaces old langston 1985 bitmap code
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "xy.h"
#include "nsc.h"
#include "sect.h"
#include "nat.h"

#define GCFx(x) ((x + WORLD_X) % WORLD_X)
#define GCFy(y) ((y + WORLD_Y) % WORLD_Y)

int
getbit(x, y, bitmap)
	int	x;
	int	y;
	u_char	*bitmap;
{
	int	id;

	id = (GCFy(y)) * WORLD_X/2 + GCFx(x)/2;
	return bitmap[id / 8] & bit(id & 07);
}

setbit(x, y, bitmap)
	int	x;
	int	y;
	u_char	*bitmap;
{
	register int id;

	id = (GCFy(y)) * WORLD_X/2 + GCFx(x)/2;
	bitmap[id / 8] |= bit(id & 07);
}

setbitmap(x, y, bitmap, bitmaps)
	register int x;
	register int y;
	register u_char *bitmap;
	int	*bitmaps;
{
	register int *mp;
	register int id;
	register int dx, dy;

	for (mp = bitmaps; *mp != 9999; ) {
		dx = x + *mp++;
		dy = y + *mp++;
		id = (GCFy(dy)) * WORLD_X/2 + GCFx(dx)/2;
		bitmap[id / 8] |= bit(id & 07);
	}
}


/*
 * if we're not god, we have to set up the bitmaps
 * correctly for the owned sectors.  If we are god,
 * forego all this (expensive) nonsense!
 */
int
bitinit(np, bitmap)
	struct	nstr_sect *np;
	u_char	*bitmap;
{
	extern	int *bitmaps[];
	struct	sctstr sect;
	int	eff;

	while (nxtsct(np, &sect)) {
		if (!owner)
			continue;
		eff = sect.sct_effic / 20;
		if (eff > 4)
			eff = 4;
		setbitmap(np->x, np->y, bitmap, bitmaps[eff]);
	}
	snxtsct_rewind(np);
}

/*
 *
 * the bit offsets for each bit pattern based on the efficiency of
 * the sector.
 *
 * bitmap0:  0-20%
 * bitmap1: 21-40%
 * bitmap2: 41-60%
 * bitmap3: 61-80%
 * bitmap4: 81-100%
 */

#define bitoff(x, y) x, y 

int bitmap0[] = {
	bitoff(-1,-1), bitoff(1,-1),
	bitoff(-2,0), bitoff(0,0), bitoff(2,0),
	bitoff(-1,1), bitoff(1,1),
	bitoff(9999,9999),
};

int bitmap1[] = {
	bitoff(0,-2),
	bitoff(-3,-1), bitoff(-1,-1), bitoff(1,-1), bitoff(3,-1),
	bitoff(-2,0), bitoff(0,0), bitoff(2,0),
	bitoff(-3,1), bitoff(-1,1), bitoff(1,1), bitoff(3,1),
	bitoff(0,2),
	bitoff(9999,9999),
};

int bitmap2[] = {
	bitoff(-2,-2), bitoff(0,-2), bitoff(2,-2),
	bitoff(-3,-1), bitoff(-1,-1), bitoff(1,-1), bitoff(3,-1),
	bitoff(-4,0), bitoff(-2,0), bitoff(0,0), bitoff(2,0), bitoff(4,0),
	bitoff(-3,1), bitoff(-1,1), bitoff(1,1), bitoff(3,1),
	bitoff(-2,2), bitoff(0,2), bitoff(2,2),
	bitoff(9999,9999),
};

int bitmap3[] = {
	bitoff(-1,-3), bitoff(1,-3),
	bitoff(-4,-2), bitoff(-2,-2), bitoff(0,-2), bitoff(2,-2), bitoff(4,-2),
	bitoff(-5,-1), bitoff(-3,-1), bitoff(-1,-1), bitoff(1,-1),
		bitoff(3,-1), bitoff(5,-1),
	bitoff(-4,0), bitoff(-2,0), bitoff(0,0), bitoff(2,0), bitoff(4,0),
	bitoff(-5,1), bitoff(-3,1), bitoff(-1,1), bitoff(1,1),
		bitoff(3,1), bitoff(5,1),
	bitoff(-4,2), bitoff(-2,2), bitoff(0,2), bitoff(2,2), bitoff(4,2),
	bitoff(-1,3), bitoff(1,3),
	bitoff(9999,9999),
};

int bitmap4[] = {
	bitoff(-3,-3), bitoff(-1,-3), bitoff(1,-3), bitoff(3,-3),
	bitoff(-4,-2), bitoff(-2,-2), bitoff(0,-2), bitoff(2,-2), bitoff(4,-2),
	bitoff(-5,-1), bitoff(-3,-1), bitoff(-1,-1), bitoff(1,-1),
		bitoff(3,-1), bitoff(5,-1),
	bitoff(-6,0), bitoff(-4,0), bitoff(-2,0), bitoff(0,0), bitoff(2,0),
		bitoff(4,0), bitoff(6,0),
	bitoff(-5,1), bitoff(-3,1), bitoff(-1,1), bitoff(1,1),
		bitoff(3,1), bitoff(5,1),
	bitoff(-4,2), bitoff(-2,2), bitoff(0,2), bitoff(2,2), bitoff(4,2),
	bitoff(-3,3), bitoff(-1,3), bitoff(1,3), bitoff(3, 3),
	bitoff(9999,9999),
};

int *bitmaps[5] = {
	bitmap0,
	bitmap1,
	bitmap2,
	bitmap3,
	bitmap4,
};
