#ifndef lint
static char *RCSid = "$Header: vers.c,v 1.11 89/09/28 01:36:38 mr-frog Exp $";
#endif /* not lint */

/*
 * vers.c
 *
 * empire version (probably out of date by now!)
 *
 * from PSL Empire, 1985
 */

#include <stdio.h>
#include <time.h>
#include "gamesdef.h"
#include "misc.h"
#include "deity.h"
#include "nat.h"
#include "version.h"

char	*options[] = {
#ifdef	ALLYHARBOR
			"ALLYHARBOR",
#endif	ALLYHARBOR
#ifdef	SHOWPLANE
			"SHOWPLANE",
#endif	SHOWPLANE
#ifdef	DROPANY
			"DROPANY",
#endif	DROPANY
#ifdef	REJECTS
			"REJECTS",
#endif	REJECTS
#ifdef	BMAP
			"BMAP",
#endif	BMAP
#ifdef	AUTONAV
			"AUTONAV",
#endif	AUTONAV
#ifdef	SCUTTLE
			"SCUTTLE",
#endif	SCUTTLE
#ifdef	CONVASAT
			"CONVASAT",
#endif	CONVASAT
#ifdef	ORBIT
			"ORBIT",
#endif	ORBIT
#ifdef	ABM
			"ABM",
#endif	ABM
#ifdef	GRIND
			"GRIND",
#endif	GRIND
#ifdef	PINPOINTMISSILE
			"PINPOINTMISSILE",
#endif	PINPOINTMISSILE
#ifdef	FALLOUT
			"FALLOUT",
#endif	FALLOUT
#ifdef	SAIL
			"SAIL",
#endif	SAIL
#ifdef	NUKEFAILDETONATE
			"NUKEFAILDETONATE",
#endif	NUKEFAILDETONATE
#ifdef	MISSINGMISSILES
			"MISSINGMISSILES",
#endif	MISSINGMISSILES
#ifdef	SHIPNAMES
			"SHIPNAMES",
#endif	SHIPNAMES
#ifdef	NEUTRON
			"NEUTRON",
#endif	NEUTRON
#ifdef	NONUKESUB
			"NONUKESUB",
#endif	NONUKESUB
#ifdef	BETTERABM
			"BETTERABM",
#endif	BETTERABM
#ifdef	RANGEEDIT
			"RANGEEDIT",
#endif	RANGEEDIT
#ifdef	MISSDEF
			"MISSDEF",
#endif	MISSDEF
#ifdef	SHIPSAM
			"SHIPSAM",
#endif	SHIPSAM
#ifdef	NOFOOD
			"NOFOOD",
#endif	NOFOOD
#ifdef	BIND
			"BIND",
#endif	BIND
#ifdef	SHIPINTER
			"SHIPINTER",
#endif	SHIPINTER
#ifdef	INCARRANGE
			"INCARRANGE",
#endif	INCARRANGE
#ifdef	DEMANDUPDATE
			"DEMANDUPDATE",
#endif	DEMANDUPDATE
#ifdef	UPDATESCHED
			"UPDATESCHEDULING",
#endif	UPDATESCHED
#ifdef	MERC
			"MERC",
#endif	MERC

			NULL
		};

vers()
{
	extern	int s_p_etu;
	extern	int etu_per_update;
	extern	int adj_update;
	extern	int m_m_p_d;
	extern	int players_at_00;
	extern	float btu_build_rate;
	extern	double fgrate, fcrate;
	extern	double eatrate, babyeat;
	extern	double obrate, uwbrate;
	extern	double bankint;
	extern	double hap_cons, edu_cons;
	extern	double money_civ, money_uw, money_mil, money_res;
	extern	float hap_avg, edu_avg, ally_factor;
	extern	float level_age_rate;
/*	extern	float easy_tech, hard_tech, tech_log_base; */
	extern	float easy_tech, tech_log_base;
	time_t	now;
	time_t	upd_time;
	time_t	next_update;
	int	secs_per_update;
	int	delta;
	int	i,j;

	(void) time(&now);
	upd_time = now + adj_update;
	secs_per_update = etu_per_update * s_p_etu;
	delta = secs_per_update - (upd_time % secs_per_update);
	next_update = now + delta;
	pr(fmt("BSD Empire %d.%d patch level %d (KSU distribution %2.2f)\n\n",
		EMP_VERS_MAJOR, EMP_VERS_MINOR, EMP_VERS_PATCH,
		(float)KSU_DIST));
	pr("The following parameters have been set for this game:\n");
	pr(fmt("World size is %d by %d.\n", WORLD_X, WORLD_Y));
	pr(fmt("There can be up to %d countries.\n", MAXNOC));
	pr(fmt("By default, countries use %s coordinate system.\n",
		(players_at_00) ? "the deity's" : "their own"));
	pr("\n");
	pr(fmt("An Empire time unit is %d second%s long.\n",
		s_p_etu, s_p_etu != 1 ? "s" : ""));
	pr(fmt("The next update is at %19.19s.\n",ctime(&next_update)));
	pr(fmt("The current time is %19.19s.\n",ctime(&now)));
	pr(fmt("An update consists of %d empire time units.\n",
		etu_per_update));
	pr(fmt("Each country is allowed to be logged in %d minutes a day.\n",
		m_m_p_d));
	pr(fmt("It takes %.2f civilians to produce a BTU in one time unit.\n",
		(1.0/(btu_build_rate*100.0))));
	pr("\n");

	pr(fmt("A non-aggi, 100 fertility sector can grow %.2f food per etu.\n",
		100.0 * fgrate));
	pr(fmt("1000 civilians will harvest %.1f food per etu.\n",
			1000.0*fcrate));
	pr(fmt("1000 civilians will give birth to %.1f babies per etu.\n", 
			1000.0*obrate));
	pr(fmt("1000 uncompensated workers will give birth to %.1f babies.\n", 
			1000.0*uwbrate));
#ifdef	NOFOOD
	pr("No food is needed!!\n");
#else
	pr(fmt("In one time unit, 1000 people eat %.1f units of food.\n", 
			1000.0*eatrate));
#endif	NOFOOD
	pr(fmt("1000 babies eat %.1f units of food becoming adults.\n", 
			1000.0*babyeat));
	pr("\n");

	pr(fmt("Banks pay $%.2f in interest per 1000 gold bars per etu.\n",
		bankint*1000.0));
	pr(fmt("1000 civilians generate $%.2f, uncompensated workers $%.2f each time unit.\n", 1000.0*money_civ, 1000.0*money_uw));
	pr(fmt("1000 active military cost $%.2f, reserves cost $%.2f.\n",
		-money_mil*1000.0, -money_res*1000.0));
	pr("\n");

	pr(fmt("Happiness p.e. requires 1 happy stroller per %d civ.\n",
		(int) hap_cons));
	pr(fmt("Education p.e. requires 1 class of graduates per %d civ.\n",
		(int) edu_cons));
	pr(fmt("Happiness is averaged over %d time units.\n", (int)hap_avg));
	pr(fmt("Education is averaged over %d time units.\n", (int)edu_avg));
	pr(fmt(
	"The technology/research boost you get from your allies is %.2f%%.\n",
		100.0/ally_factor));
	pr(fmt("Nation levels (tech etc.) decline 1%% every %d time units.\n",
		(int)(level_age_rate)));

	pr("Tech Buildup is ");
/*	if (tech_log_base <= 1.0 && hard_tech == 0.0) { */
	if (tech_log_base <= 1.0 ) {
		pr("not limited\n");
	} 
	if (tech_log_base > 1.0) {
		pr(fmt("limited to logrithmic growth (base %.2f)",
			tech_log_base));
#ifdef MERC
		if (easy_tech == 0.0) 
			pr(".\n");
		else
			pr(fmt(" after %0.2f.\n", easy_tech));
#else
		if (easy_tech + tech_log_base == 0.0) 
			pr(".\n");
		else
			pr(fmt(" after %0.2f.\n", easy_tech + tech_log_base));
#endif
	} /*else {
		pr(fmt("limited to asymptotic growth towards %.2f",
			hard_tech + easy_tech));
		if (easy_tech == 0.00) 
			pr(".\n");
		else
			pr(fmt("after %.2f\n",easy_tech));
	} */

	pr("\nOptions enabled in this game:\n        ");
	for (i=0,j=0; options[i] != NULL; i++) {
		j += strlen(options[i]) + 2;
		if (j > 70) {
			pr("\n        ");
			j = strlen(options[i]) + 2;
		}
		pr(fmt("%s%s",options[i],(options[i+1] == NULL) ? "" : ", "));
	}
	pr("\n\n");
	pr(fmt("The person to annoy if something goes wrong is %s\n\t\t(%s).\n",
		privname, privlog));
	pr(fmt("You can get your own copy of the source %s\n",GET_SOURCE));
	return RET_OK;
}
