#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/scra.c,v 1.4 89/08/17 15:15:29 jeffw Exp $";
#endif /* not lint */

/*
 * scra.c
 *
 * Scrap ships or planes
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"

union item_u {
	struct shpstr ship;
	struct plnstr plane;
};

scra()
{
	extern	char *argp[];
	struct	nstr_item ni;
	union	item_u item;
	int	vec[I_MAX+1];
	int	itemvec[I_MAX+1];
	int	type;
	struct	sctstr sect;
	struct	mchrstr *mp;
	struct	plchrstr *pp;
	char	*p;
	int	i;

	if ((p = getstarg(argp[1], "Ship or plane? ")) == 0)
		return RET_SYN;
	type = ef_byname(p);
	if (type == EF_SECTOR)
		type = EF_SHIP;
	if (type != EF_SHIP && type != EF_PLANE) {
		pr("Ships or planes only!\n");
		return RET_SYN;
	}
	if (!snxtitem(&ni, type, argp[2]))
		return RET_SYN;
	while (nxtitem(&ni, (char *)&item)) {
		if (!owner)
			continue;
		if (type == EF_SHIP) {
			getsect(item.ship.shp_x, item.ship.shp_y, &sect);
			if (sect.sct_type != SCT_HARBR)
				continue;
		} else {
			getsect(item.plane.pln_x, item.plane.pln_y, &sect);
			if (sect.sct_type != SCT_AIRPT)
				continue;
		}
		if (sect.sct_effic < 60 || sect.sct_own != cnum)
			continue;
		getvec(VT_ITEM, vec, (char *)&sect, EF_SECTOR);
		if (type == EF_SHIP) {
			mp = &mchr[item.ship.shp_type];
			pr(mp->m_name);
#ifdef	SHIPNAMES
			pr(" ");
			pr(item.ship.shp_name);
#endif	SHIPNAMES
			getvec(VT_ITEM, itemvec, (char *)&item.ship, EF_SHIP);
			for (i = 1; i <= I_MAX; i++) {
				vec[i] += itemvec[i];
			}
			vec[I_LCM] += mp->m_lcm * 2 / 3;
			vec[I_HCM] += mp->m_hcm * 2 / 3;
			item.ship.shp_own = 0;
			putship(item.ship.shp_uid, (char *)&item.ship);
		} else {
			pp = &plchr[item.plane.pln_type];
			pr(pp->pl_name);
			vec[I_LCM] += pp->pl_lcm * 2 / 3;
			vec[I_HCM] += pp->pl_hcm * 2 / 3;
			vec[I_MILIT] += pp->pl_crew;
			item.plane.pln_own = 0;
			putplane(item.plane.pln_uid, (char *)&item.plane);
		}
#ifdef	SHIPNAMES
		pr(fmt("(#%d) scrapped in %s\n", ni.cur,
#else
		pr(fmt(" #%d scrapped in %s\n", ni.cur,
#endif	SHIPNAMES
			xyas(sect.sct_x, sect.sct_y, cnum)));
		putvec(VT_ITEM, vec, (char *)&sect, EF_SECTOR);
		putsect(&sect);
	}
	return RET_OK;
}
