
/*
 * empmap.c 
 *
 * reads the sectors file and Display the world using X windows
 *
 * Yaser Doleh 1990
 * 
 */

#include "misc.h"
#include "sect.h"
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Cardinals.h>

#define NATIONS 50

static void ExposeAction();

static XtActionsRec actions[] = {
	{ "ExposeAction",	ExposeAction }
};

static char trans_string[] = "<Expose>: ExposeAction()\n";

Widget toplevel, simple;
XtTranslations  trans;
GC	gc[NATIONS + 3];
char	*sectfil="/usr1/users/empire/EMP/data/sector";

struct	sctstr sects[WORLD_Y*WORLD_X/2];
char    s[WORLD_X][WORLD_Y];

main(argc, argv)
	int     argc;
	char  **argv;
{
	Arg	args[10];
	int	n, i;

	get_sect_file();
	
	toplevel = XtInitialize("xempMap", "XEmpMap", NULL, 0, &argc, &argv);

	n = 0;
	XtSetArg( args[n], XtNheight,  WORLD_Y*5); n++;
	XtSetArg( args[n], XtNwidth, WORLD_X*5); n++;
	simple = XtCreateManagedWidget("Simple", simpleWidgetClass,
			toplevel, args, n);
	XtRealizeWidget(toplevel);
	XtAddActions(actions, XtNumber(actions));
	trans = XtParseTranslationTable(trans_string);
	XtOverrideTranslations(simple, trans);
	
	for(i=0; i<NATIONS + 3; i++) {
		XGCValues	values;

		values.foreground = i;
		gc[i] = XCreateGC(XtDisplay(toplevel), 
			XtWindow(toplevel), GCForeground, &values);
	}
	
	XtMainLoop();
}

static void ExposeAction(w,  event, params, nparams)
Widget w;
XEvent *event;
String *params;
Cardinal *nparams;
{
	int	x, y;
	GC	dgc;
	struct sctstr *sp = sects;

	for (y = 0; y < WORLD_Y; y++) {
		for (x = 0; x < WORLD_X; x++) {
			if (((x ^ y) & 1))
				continue;
			if (sp->sct_type == SCT_MOUNT) {
			 	dgc = gc[1];	
			} else if (sp->sct_type == SCT_WATER) {
				dgc = gc[0];
			} else {
				dgc = gc[sp->sct_own + 2];
			}
			sp++;
	XFillRectangle(XtDisplay(w), XtWindow(w), dgc, x*5, y*5, 9, 5);
		}
	}

}

get_sect_file()
{
	int     sectf;

	sectf = open(sectfil, 0);
	if (sectf < 0) {
		perror(sectfil);
		exit(1);
	}
	read(sectf, sects, sizeof(sects));
	close(sectf);
}
