#ifndef lint
static char *RCSid = "$Header: desi.c,v 1.1 89/12/14 08:19:39 jay Exp $";
#endif /* not lint */

/*
 * desi.c
 *
 * redesignate sectors
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "xy.h"
#include "path.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"
#include "nat.h"

desi()
{
	extern	char *argp[];
	extern	int aborted;
	register int n;
	char	*p;
	int	des;
	int	breaksanct;
	int	sanct_x;
	int	sanct_y;
	int	cap_x;
	int	cap_y;
	int     cost = 0;
	struct	nstr_sect nstr;
	struct	sctstr sect;
	struct	sctstr check;
	struct	natstr *natp;

	breaksanct = 0;
	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	natp = getnatp(cnum);
	cap_x = natp->nat_xcap;
	cap_y = natp->nat_ycap;
	while (!aborted && nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (!god) {
			if (sect.sct_type == SCT_MOUNT ||
			    sect.sct_type == SCT_BSPAN ||
			    sect.sct_type == SCT_WASTE)
				continue;
		}
		p = fmt("%s %d%% %s  desig? ", 
			xyas(sect.sct_x, sect.sct_y, cnum),
			sect.sct_effic, dchr[sect.sct_type].d_name);
		if ((p = getstarg(argp[2], p)) == 0)
			continue;
		des = typematch(p, EF_SECTOR);
		if (des < 0 || (des == SCT_BSPAN && !god)) {
			pr("See \"info sector-types\"\n");
			continue;
		}
		if (!god) {
#ifdef CARNAGE
		        if (des == SCT_RUINS)
			  pr("you must raze a sector to make it a ruins\n");
#endif CARNAGE		  
			if (des == SCT_WATER || des == SCT_MOUNT ||
			    des == SCT_SANCT) {
 				pr(fmt("Only %s can make a %s!\n", cname(0),
					dchr[des].d_name));
				continue;
			}
			if (des == SCT_WASTE) {
				pr(fmt("Only a nuclear device (or %s) can make a %s!\n",
					cname(0), dchr[des].d_name));
				continue;
			}
		}
		if (sect.sct_type == des && sect.sct_newtype == des)
			continue;
		if (sect.sct_type == SCT_SANCT) {
			breaksanct++;
			sanct_x = nstr.x;
			sanct_y = nstr.y;
		}
		if (sect.sct_x == cap_x && sect.sct_y == cap_y &&
				des != SCT_CAPIT && des != SCT_SANCT)
			pr("You have redesignated your capitol!\n");
#ifdef CARNAGE
/*
		if (des == SCT_BHEAD) cost += 200;
		if (des == SCT_CAPIT) cost += 500;
		if (des == SCT_WAREH) cost += 200;
		if (des == SCT_FORTR) cost += 100;
*/

		if ((des == SCT_HARBR)||(des == SCT_BHEAD)) {
#else
		if (des == SCT_HARBR) {
#endif
			for (n = 1; n <= 6; n++) {
				getsect(nstr.x + diroff[n][0],
					nstr.y + diroff[n][1], &check);
				if (check.sct_type == SCT_WATER)
					break;
				if (check.sct_type == SCT_BSPAN)
					break;
			}
			if (n > 6) {
				pr(fmt("%s does not border on water.\n",
					xyas(nstr.x, nstr.y, cnum)));
				if (god)
					pr("But if it's what you want ...\n");
				else
					continue;
			}
		}
		if (sect.sct_type == SCT_SANCT && !god)
			continue;
		n = sect.sct_type;
		if (sect.sct_effic < 5 || god) {
			sect.sct_type = des;
			sect.sct_effic = 0;
#if	defined(BMAP) || defined(AUTONAV)
			setbigmap(sect.sct_x, sect.sct_y, dchr[des].d_mnem);
			writebigmap();
#endif
		}
		sect.sct_newtype = des;
		putsect(&sect);
		if (n != SCT_BHEAD)
			continue;
		bridgefall(&sect);
	}
	if (breaksanct)
		bsanct(sanct_x, sanct_y);
	if (cost>0) pr(fmt("that just cost you $%d\n",cost));
#ifdef CARNAGE
	NAT_DELTA(nat_money, cnum, -cost);
#endif
	return 0;
}
