#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/common/RCS/nat.c,v 1.2 89/05/28 16:10:27 emp-src Exp $";
#endif

/*
 * nat.c
 *
 * misc accesses on the nation file,
 * just associated with the in-memory copy.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "nat.h"
#include "file.h"

char *
cname(n)
	natid	n;
{
	struct	natstr *np;

	if ((np = getnatp(n)) == 0)
		return 0;
	return np->nat_cnam;
}

char *
relatename(np, other)
	struct	natstr *np;
	natid	other;
{
	extern	char *relates[];

	return relates[getrel(np, other)];
}

#ifdef	REJECTS
char *
rejectname(np, other)
	struct	natstr *np;
	natid	other;
{
	extern char	*rejects[];

	return rejects[getrejects(other, np)];
}
#endif	REJECTS

char *
natstate(np)
	struct	natstr *np;
{
	if ((np->nat_stat & STAT_INUSE) == 0)
		return "FREE";
	if (np->nat_stat & STAT_GOD)
		return "DEITY";
	if ((np->nat_stat & STAT_NORM) == 0)
		return "VISITOR";
	return "ACTIVE";
}

int
getrel(np, them)
	struct	natstr *np;
	natid	them;
{
	int	ind;
	int	shift;
	int	relate;

#ifdef CARNAGE
	ind = them / 5;
	shift = (them % 5) * 3;
	relate = (np->nat_relate[ind] >> shift) & 07;
	return relate;
#else
	ind = them / 8;
	shift = 14 - ((them - ((them / 8) << 3)) * 2);
	relate = (np->nat_relate[ind] >> shift) & 03;
	return relate;
#endif
}

#ifdef	REJECTS
int
getrejects(them, np)
	natid	them;
	struct	natstr *np;
{
	int	ind;
	int	shift;
	int	reject;

	ind = them / 4;
	shift = 12 - ((them - ((them / 4) << 2)) * 4);
	/* the 07 should *really* be 017 */
	reject = (np->nat_rejects[ind] >> shift) & 0x0f;
	return reject;
}
#endif	REJECTS

putrel(np, them, relate)
	struct	natstr *np;
	natid	them;
	int	relate;
{
	int	shift;
	int	newrel;
	int	ind;

#ifdef CARNAGE
	relate &= 07;
	ind = them / 5;
	shift = (them % 5) * 3;
	newrel = np->nat_relate[ind];
	newrel &= ~(07 << shift);
	newrel |= (relate << shift);
#else
	relate &= 03;
	ind = them / 8;
	shift = 14 - ((them - ((them / 8) << 3)) * 2);
	newrel = np->nat_relate[ind];
	newrel &= ~(03 << shift);
	newrel |= (relate << shift);
#endif
	np->nat_relate[ind] = newrel;
}

#ifdef	REJECTS
putreject(np, them, how, what)
	struct	natstr *np;
	natid	them;
	int	how;
	int	what;
{
	int	shift;
	int	newrej;
	int	ind;

	/* This 07 should be changed to 017 after the current game is over */
	what &= 0x0f;
	ind = them / 4;
	shift = 12 - ((them - ((them / 4) << 2)) * 4);
	newrej = np->nat_rejects[ind];
	if (how)
		newrej |= (what << shift);
	else
		newrej &= ~(what << shift);
	np->nat_rejects[ind] = newrej;
}
#endif	REJECTS
