/*
 * sect.h
 *
 * things having to do with sectors
 *
 * from PSL Empire, 1985
 * $Revision: 1.6 $ $Date: 89/06/01 14:18:51 $
 */


/*
 * each "point" of MAXSCTV costs 32k for 128x128.
 * MAXSCTV = 20 ==> 655k for the commodities alone!
 */
#define	MAXSCTV 20

struct	sctstr {
	coord	sct_x;		/* x coord of sector */
	coord	sct_y;		/* y coord of sector */
	natid	sct_own;	/* owner's country num */
	u_char	sct_type;	/* sector type */
	u_char	sct_effic;	/* 0% to 100% */
	u_char	sct_mobil;	/* mobility units */
	u_char	sct_loyal;	/* updates until civilans "converted" */
	u_char	sct_terr;	/* territory id # of sector */
	long	sct_distpath;	/* sector distribution deliver path */
	short	sct_elev;	/* elevation/depth */
	short	sct_avail;	/* available workforce for "other things" */
	short	sct_fill;	/* gunk */
	u_char	sct_work;	/* pct of civ actually working */
	u_char	sct_flags;	/* sector flags */
	u_char	sct_newtype;	/* for changing designations */
	u_char	sct_min;	/* ease of mining ore */
	u_char	sct_gmin;	/* amount of gold ore */
	u_char	sct_fertil;	/* fertility of soil */
	u_char	sct_oil;	/* oil content */
	u_char	sct_uran;	/* uranium ore content */
	natid	sct_oldown;	/* old owner of sector (for liberation) */
	u_char	sct_nv;		/* current number of variables */
	u_char	sct_vtype[MAXSCTV];
	u_short	sct_vamt[MAXSCTV];
};

struct	dchrstr	{
	int	d_mnem;		/* map symbol */
	int	d_prd;		/* product vtype */
	int	d_mcst;		/* movement cost */
	int	d_flg;		/* movement cost */
	int	d_pkg;		/* type of packaging in these sects */
	int	d_ostr;		/* offensive strength */
	int	d_dstr;		/* defensive strength */
	int	d_value;	/* resale ("collect") value */
	char	*d_name;	/* full name of sector type */
};

#define	NPKG	0		/* no special packaging */
#define	WPKG	1		/* "warehouse" packaging */
#define	UPKG	2		/* "urban" packaging */
#define	BPKG	3		/* "bank" packaging */

/* for d_flg */
#define	NAVOK	1		/* ships can always navigate */
#define	NAV_02	2		/* requires 2% effic to navigate */
#define	NAV_60	3		/* requires 60% effic to navigate */

	/* sector types (must agree with order in dchr, empglb.c) */

#define	SCT_WATER	0       /* basics */
#define	SCT_MOUNT	1
#define	SCT_SANCT	2
#define	SCT_WASTE	3
#define	SCT_RURAL	4
#define	SCT_CAPIT	5
#define	SCT_URAN	6
#define	SCT_PARK	7
#define	SCT_ARMSF	8       /* industries */
#define	SCT_AMMOF	9
#define	SCT_MINE	10
#define	SCT_GMINE	11
#define	SCT_HARBR	12
#define	SCT_WAREH	13
#define	SCT_AIRPT	14
#define	SCT_AGRI	15
#define	SCT_OIL		16
#define	SCT_LIGHT	17
#define	SCT_HEAVY	18
#define	SCT_FORTR	19      /* military/scientific */
#define	SCT_TECH	20
#define	SCT_RSRCH	21
#define	SCT_NUKE	22
#define	SCT_LIBR	23
#define	SCT_HIWAY	24      /* communications */
#define	SCT_RADAR	25
#ifdef CARNAGE
#define	SCT_RUINS	26
#else
#define	SCT_WETHR	26
#endif CARNAGE
#define	SCT_BHEAD	27
#define	SCT_BSPAN	28
#define	SCT_BANK	29      /* financial */
#define	SCT_REFINE	30	/* refinery */
#define SCT_ENLIST	31	/* enlistment center */

#define	SCT_MAXDEF	31	/* highest sector type in header files */

#define getsect(x, y, p) \
	ef_nbread(EF_SECTOR, sctoff((int) x, (int) y), (caddr_t)p)
#define putsect(p) \
	ef_nbwrite(EF_SECTOR, sctoff((int) (p)->sct_x, \
		(int) (p)->sct_y), (caddr_t)p)
#define getsectp(x, y) \
	(struct sctstr *) ef_ptr(EF_SECTOR, sctoff((int)x, (int)y))
#define getsectid(id) \
	(struct sctstr *) ef_ptr(EF_SECTOR, id)

/* things relating to sectors */
extern	int sctoff();
extern	double landgun();

extern	int sct_maxno;
extern	struct dchrstr dchr[];
