#ifndef _CORDLESS_PHONE_H_
#define _CORDLESS_PHONE_H_

#include <qwidget.h>

#include <VrTypes.h>

template<class oType> class VrAR5000Source;
template<class iType> class VrComplexFIRfilter;
template<class Type> class VrSquelch;
template<class iType, class oType> class VrRealFIRfilter;
template<class oType> class VrQuadratureDemod;
template<class iType> class VrAudioSink;

class QwtKnob;

class CordlessPhone : public QWidget
{
  Q_OBJECT

  VrAR5000Source<char> *source;
  VrComplexFIRfilter<char> *chanFilter;
  VrSquelch<complex> *squelch;
  VrQuadratureDemod<float> *demod;
  VrRealFIRfilter<float, short> *ifFilter;
  VrAudioSink<short> *audio;

  QwtKnob *vol;
  QwtKnob *sq;

public:
  CordlessPhone(VrAR5000Source<char> *source,
	     QWidget *parent = 0, const char *name = 0);
  ~CordlessPhone();

  virtual QSize sizeHint() const;

private slots:
  void run();

public slots:
  void setVolume(double volume);
};

#endif
