/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _INCLUDED_GR_FLOWGRAPHIMPL_H_
#define _INCLUDED_GR_FLOWGRAPHIMPL_H_

#include <gr_FlowGraph.h>
#include <omnithread.h>
#include <vector>

class VrMultiTask;

/*!
 *  Simple concrete implementation of gr_FlowGraph.
 */

class gr_FlowGraphImpl : public gr_FlowGraph {
private:
  bool				d_run;
  bool				d_has_been_started;
  omni_mutex			d_mutex;
  omni_thread		       *d_thread;
  VrMultiTask		       *d_mt;
  std::vector<VrSigProc *>	d_sigprocs;

  bool add_sigproc (VrSigProc *);

  // NOT IMPLEMENTED
  gr_FlowGraphImpl (const gr_FlowGraphImpl &rhs);
  
public:
  // CONSTRUCTORS
  gr_FlowGraphImpl ();
  ~gr_FlowGraphImpl ();

  // MANIPULATORS
  bool start ();
  void stop ();
  void wait ();
  bool connect (VrSigProc *upstream, VrSigProc *downstream);
  bool connect (VrSigProc *upstream, int upstream_port, VrSigProc *downstream);

  // ACCESSORS
  bool isRunning ();

  VrMultiTask *mt () { return d_mt; }
};

#endif /* _INCLUDED_GR_FLOWGRAPHIMPL_H_ */
